<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html">
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <?php if(isset($isEdit) && $isEdit==1): ?>
                        <?php if($is_post == 0): ?>
                        <a class="btn btn-info" href="<?php echo $action_post; ?>">
                            <i class="fa fa-thumbs-up"></i>
                            &nbsp;<?php echo $lang['post']; ?>
                        </a>
                        <?php endif; ?>
                        <!--
                        <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                            <i class="fa fa-balance-scale"></i>
                            &nbsp;<?php echo $lang['ledger']; ?>
                        </button>-->
                        <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                            <i class="fa fa-print"></i>
                            &nbsp;<?php echo $lang['print']; ?>
                        </a>
                        <?php endif; ?>
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                        <i class="fa fa-floppy-o"></i>
                        &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" value="<?php echo $document_type_id; ?>" name="document_type_id" id="document_type_id" />
                                <input type="hidden" value="<?php echo $stock_transfer_id; ?>" name="document_id" id="document_id" />
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_no']; ?></label>
                                            <input class="form-control" type="text" name="document_identity" readonly="readonly" value="<?php echo $document_identity; ?>" placeholder="Auto" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input class="form-control dtpDate" type="text" name="document_date" value="<?php echo $document_date; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_warehouse']; ?></label>
                                            <select class="form-control" id="from_warehouse_id" name="warehouse_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($warehouses as $warehouse): ?>
                                                <option value="<?php echo $warehouse['warehouse_id']; ?>" <?php echo ($warehouse_id == $warehouse['warehouse_id']?'selected="selected"':''); ?>><?php echo $warehouse['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['container_no']; ?></label>
                                            <div class="input-group">
                                                <select class="form-control" id="container_no" name="container_no">
                                                    <option value="">&nbsp;</option>
                                                </select>
                                                <span class="input-group-btn">
                                                    <button id="addContainer" type="button" class="btn btn-info btn-flat"><i class="fa fa-plus"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row hide">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['base_currency']; ?></label>
                                            <input type="hidden" id="base_currency_id" name="base_currency_id"  value="<?php echo $base_currency_id; ?>" />
                                            <input type="text" class="form-control" id="base_currency" name="base_currency" readonly="true" value="<?php echo $base_currency; ?>" />
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['document_currency']; ?></label>
                                            <select class="form-control" id="document_currency_id" name="document_currency_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($currencys as $currency): ?>
                                                <option value="<?php echo $currency['currency_id']; ?>" <?php echo ($document_currency_id == $currency['currency_id']?'selected="selected"':''); ?>><?php echo $currency['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['conversion_rate']; ?></label>
                                            <input class="form-control fDecimal" id="conversion_rate" type="text" name="conversion_rate" value="<?php echo $conversion_rate; ?>" onchage="calcNetAmount()" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label><?php echo $lang['remarks']; ?></label>
                                            <input class="form-control" type="text" name="remarks" value="<?php echo $remarks; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="table-responsive">
                                            <table id="tblStockTransferDetail" class="table table-striped table-bordered">
                                                <thead>
                                                <tr align="center">
                                                    <td style="width: 3%;">
                                                        <!--
                                                        <a id="btnAddGrid" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                        -->
                                                    </td>
                                                    <td><?php echo $lang['warehouse']; ?></td>
                                                    <td><?php echo $lang['manual_ref_no']; ?></td>
                                                    <td><?php echo $lang['container_no']; ?></td>
                                                    <td><?php echo $lang['batch_no']; ?></td>
                                                    <td><?php echo $lang['product_code']; ?></td>
                                                    <td><?php echo $lang['product_name']; ?></td>
                                                    <td><?php echo $lang['cubic_meter']; ?></td>
                                                    <td><?php echo $lang['cubic_feet']; ?></td>
                                                    <td><?php echo $lang['quantity']; ?></td>
                                                    <td><?php echo $lang['total_cubic_meter']; ?></td>
                                                    <td><?php echo $lang['total_cubic_feet']; ?></td>
                                                    <td><?php echo $lang['cog_rate']; ?></td>
                                                    <td><?php echo $lang['amount']; ?></td>
                                                    <td style="width: 3%;">
                                                        <!--
                                                        <a id="btnAddGrid" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a>
                                                        -->
                                                    </td>
                                                </tr>
                                                </thead>
                                                <tbody >
                                                <?php $grid_row = 0; ?>
                                                <?php foreach($stock_transfer_details as $detail): ?>
                                                <tr id="grid_row_<?php echo $grid_row; ?>" data-row_id="<?php echo $grid_row; ?>">
                                                    <td><a onclick="removeRow(this);" title="Remove" class="btn btn-sm btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>
                                                    <td>
                                                        <select class="form-control select2" id="stock_transfer_detail_warehouse_id_<?php echo $grid_row; ?>" name="stock_transfer_details[<?php echo $grid_row; ?>][warehouse_id]" >
                                                            <option value="">&nbsp;</option>
                                                            <?php foreach($warehouses as $warehouse): ?>
                                                            <option value="<?php echo $warehouse['warehouse_id']; ?>" <?php echo ($warehouse['warehouse_id']==$detail['warehouse_id']?'selected="true"':'');?>><?php echo $warehouse['name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][manual_ref_no]" id="stock_transfer_detail_manual_ref_no_<?php echo $grid_row; ?>" value="<?php echo $detail['manual_ref_no']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][container_no]" id="stock_transfer_detail_container_no_<?php echo $grid_row; ?>" value="<?php echo $detail['container_no']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][batch_no]" id="stock_transfer_detail_batch_no_<?php echo $grid_row; ?>" value="<?php echo $detail['batch_no']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][product_code]" id="stock_transfer_detail_product_code_<?php echo $grid_row; ?>" value="<?php echo $detail['product_code']; ?>"  readonly/>
                                                        <input type="hidden" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][product_id]" id="stock_transfer_detail_product_id_<?php echo $grid_row; ?>" value="<?php echo $detail['product_id']; ?>"  readonly/>
                                                    </td>
                                                    <td>
                                                        <input style="min-width: 300px;" type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][product_name]" id="stock_transfer_detail_product_name_<?php echo $grid_row; ?>" value="<?php echo $detail['product_name']; ?>"  readonly/>
                                                        <input type="hidden" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][unit_id]" id="stock_transfer_detail_unit_id_<?php echo $grid_row; ?>" value="<?php echo $detail['unit_id']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cubic_meter]" id="stock_transfer_detail_cubic_meter_<?php echo $grid_row; ?>" value="<?php echo $detail['cubic_meter']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cubic_feet]" id="stock_transfer_detail_cubic_feet_<?php echo $grid_row; ?>" value="<?php echo $detail['cubic_feet']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input onchange="calculateTotal(this);" type="text" class="form-control fPDecimal" name="stock_transfer_details[<?php echo $grid_row; ?>][qty]" id="stock_transfer_detail_qty_<?php echo $grid_row; ?>" value="<?php echo $detail['qty']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cubic_meter]" id="stock_transfer_detail_total_cubic_meter_<?php echo $grid_row; ?>" value="<?php echo $detail['total_cubic_meter']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cubic_feet]" id="stock_transfer_detail_total_cubic_feet_<?php echo $grid_row; ?>" value="<?php echo $detail['total_cubic_feet']; ?>" readonly/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cog_rate]" id="stock_transfer_detail_cog_rate_<?php echo $grid_row; ?>" value="<?php echo $detail['cog_rate']; ?>" readonly />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="stock_transfer_details[<?php echo $grid_row; ?>][cog_amount]" id="stock_transfer_detail_cog_amount_<?php echo $grid_row; ?>" value="<?php echo $detail['cog_amount']; ?>" readonly />
                                                    </td>
                                                    <td><a onclick="removeRow(this);" title="Remove" class="btn btn-sm btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>
                                                </tr>
                                                <?php $grid_row++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                                <tfoot>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-offset-4 col-md-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_qty']; ?></label>
                                            <input type="text" id="total_qty" name="total_qty" value="<?php echo $total_qty; ?>" class="form-control fDecimal" readonly="readonly" />
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_meter']; ?></label>
                                            <input type="text" id="total_cubic_meter" name="total_cubic_meter" value="<?php echo $total_cubic_meter; ?>" class="form-control fDecimal" readonly="readonly" />
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_cubic_feet']; ?></label>
                                            <input type="text" id="total_cubic_feet" name="total_cubic_feet" value="<?php echo $total_cubic_feet; ?>" class="form-control fDecimal" readonly="readonly" />
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_amount']; ?></label>
                                            <input type="text" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" class="form-control fDecimal" readonly="readonly" />
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <?php if(isset($isEdit) && $isEdit==1): ?>
                                <?php if($is_post == 0): ?>
                                <a class="btn btn-info" href="<?php echo $action_post; ?>">
                                    <i class="fa fa-thumbs-up"></i>
                                    &nbsp;<?php echo $lang['post']; ?>
                                </a>
                                <?php endif; ?>
                                <!--
                                <button type="button" class="btn btn-info" href="javascript:void(0);" onclick="getDocumentLedger();">
                                    <i class="fa fa-balance-scale"></i>
                                    &nbsp;<?php echo $lang['ledger']; ?>
                                </button>-->
                                <a class="btn btn-info" target="_blank" href="<?php echo $action_print; ?>">
                                    <i class="fa fa-print"></i>
                                    &nbsp;<?php echo $lang['print']; ?>
                                </a>
                                <?php endif; ?>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <button type="button" class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();" <?php echo ($is_post==1?'disabled="true"':''); ?>>
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;<?php echo $lang['save']; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
    <script src="plugins/dataTables/jquery.dataTables.js"></script>
    <script src="plugins/dataTables/dataTables.bootstrap.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);
        var $lang = <?php echo json_encode($lang) ?>;
        var $partner_id = '<?php echo $partner_id; ?>';
        var $grid_row = '<?php echo $grid_row; ?>';
        var $products = <?php echo json_encode($products) ?>;
        var $warehouses = <?php echo json_encode($warehouses) ?>;
        var $UrlGetContainers = '<?php echo $href_get_containers; ?>';
        var $UrlGetContainerData = '<?php echo $href_get_container_data; ?>';
    </script>
    <script type="text/javascript" src="../admin/view/js/inventory/stock_transfer.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>