<?php echo $header; ?>
<?php echo $column_left; ?>
<div id="page-wrapper">
    <?php if ($error_warning) { ?>
    <div class="warning"><?php echo $error_warning; ?></div>
    <?php } ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-default">
                <div class="panel-heading heading">
                    <?php echo $heading_title; ?>
                    <ul style="float: right;" class="list-nostyle list-inline">
                        <li><a class="btn btn-outline btn-default btn-sm" href="<?php echo $cancel; ?>"><i class="fa fa-undo"></i><?php echo $button_cancel; ?></a></li>
                        <li><a class="btn btn-outline btn-primary btn-sm" href="javascript:void(0);" onclick="$('#form').submit();"><i class="fa fa-floppy-o"></i><?php echo $button_save; ?></a></li>
                    </ul>
                </div>
                <div class="panel-body">
                    <form  action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label><?php echo $entry_invoice_no; ?></label>
                                    <input class="form-control" type="text" id="invoice_number" 
                                            name="invoice_no" readonly="readonly" 
                                    value="<?php echo $invoice_no; ?>" placeholder="auto" />

                                    <?php if (isset($error['invoice_no'])) { ?>
                                    <span class="error"><?php echo $error['invoice_no']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>       
                            <div class="col-sm-3">      
                                <div class="form-group">
                                    <label><?php echo $entry_invoice_date; ?></label>
                                    <input class="form-control dtpDate" type="text" name="invoice_date" value="<?php echo $invoice_date; ?>" />
                                    <?php if (isset($error['invoice_date'])) { ?>
                                    <span class="error"><?php echo $error['invoice_date']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>	
                            		
                            <div class="col-sm-3">   
                                <div class="form-group">
                                    <label><?php echo $entry_customer_id; ?></label>
                                    <select class="form-control" name="customer_id">
                                        <?php foreach($customers as $customer): ?>
                                        <option value="<?php echo $customer['customer_id']; ?>" 
                                                <?php echo ($customer_id == $customer['customer_id']?'selected="selected"':''); ?>"><?php echo $customer['name']; ?></option>   
                                        <?php endforeach; ?>	
                                    </select>
                                </div>
                            </div>    
                            
                            <div class="col-sm-3">    
                                <div class="form-group">
                                    <label><?php echo $entry_terms; ?></label>
                                    <input class="form-control" type="text" name="terms" value="<?php echo $terms; ?>" />
                                </div>
                            </div>  
                        </div>
                        <div class="row">          
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo $entry_remarks; ?></label>
                                    <input class="form-control" type="text" name="remarks" value="<?php echo $remarks; ?>" />
                                    <?php if (isset($error['remarks'])) { ?>
                                    <span class="error"><?php echo $error['remarks']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-sm-6">   
                                <div class="form-group">
                                    <label><?php echo $entry_remarks2; ?></label>
                                    <input class="form-control" type="text" name="remarks2" value="<?php echo $remarks2; ?>" />
                                    <?php if (isset($error['remarks2'])) { ?>
                                    <span class="error"><?php echo $error['remarks2']; ?></span>
                                    <?php } ?>
                                </div>
                            </div>  
                        </div>      
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="table-responsive table-bordered tbl_grid">
                                    <table id="sale_order" class="table form-grid table-striped table-hover flat-grid">
                                        <thead>
                                            <tr align="center">
                                                <td style="width: 10%"><?php echo $column_code; ?></td>
                                                <td style="width: 25%"><?php echo $column_name; ?></td>
                                                <td style="width: 20%"><?php echo $column_unit; ?></td>
                                                <td><?php echo $column_quantity; ?></td>
                                                <td><?php echo $column_rate; ?></td>
                                                <td><?php echo $column_amount; ?></td>
                                                <td><a id="btnAddGrid" title="Add" href="javascript:void(0);" onclick="addService();"><span class="fa fa-plus"></span></a></td>
                                            </tr>
                                        </thead>
                                        <?php $service_row = 0; ?>
                                        <?php foreach($sale_order_details as $detail): ?>
                                        <tbody id="service_row_<?php echo $service_row; ?>" row_id="<?php echo $service_row; ?>">
                                            <tr>
                                                <td>
                                                    <input  type="text" name="sale_order_detail[<?php echo $service_row; ?>][product_code]" id="sale_order_detail_code_<?php echo $service_row; ?>" class="form-control" value="<?php echo $detail[product_code]; ?>" onchange="getProductInformationCode(<?php echo service_row; ?>)" />
                                                </td>
                                                <td>
                                                <div class="form-group input-group">
                                                    <select class="" id="sale_order_detail_product_id_<?php echo $service_row; ?>" name="sale_order_detail[<?php echo $service_row; ?>][product_id]" onchange="getProductInformation(<?php echo service_row; ?>)">
                                                        <?php foreach($products as $product): ?>
                                                        <option value="<?php echo $product['product_id']; ?>" <?php echo ($detail['product_id'] == $product['product_id']?'selected="selected"':''); ?>"><?php echo $product['name']; ?></option>   
                                                        <?php endforeach; ?>
                                                    </select>
                                                           <span class="input-group-btn">
                                                        <input type="button"  model="setup/product" ref_id="sale_order_detail_product_id_<?php echo $service_row; ?>" callback="getProductInformation" value="..." class="QSearch btn btn-default" />
                                                   </span>
                                                     </div>
                                                </td>
                                                <td>
                                                        <select class="" id="sale_order_detail_unit_id_<?php echo $service_row; ?>" name="sale_order_detail[<?php echo $service_row; ?>][unit_id]">
                                                        <?php foreach($units as $unit): ?>
                                                        <option value="<?php echo $unit['unit_id']; ?>" <?php echo ($detail['unit_id'] == $unit['unit_id']?'selected="selected"':''); ?>"><?php echo $unit['name']; ?></option>
                                                    <?php endforeach; ?>	
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="fDecimal" id="sale_order_detail_qty_<?php echo $service_row; ?>" name="sale_order_detail[<?php echo $service_row; ?>][qty]" value="<?php echo $detail['qty']; ?>" onchange="calcRowTotal('<?php echo $service_row; ?>','qty')" />
                                                </td>
                                                <td>
                                                    <input type="text" class="fDecimal" id="sale_order_detail_rate_<?php echo $service_row; ?>" name="sale_order_detail[<?php echo $service_row; ?>][rate]" value="<?php echo $detail['rate']; ?>" onchange="calcRowTotal('<?php echo $service_row; ?>','rate')" />
                                                </td>
                                                <td>
                                                    <input type="text" class="fDecimal" id="sale_order_detail_amount_<?php echo $service_row; ?>" name="sale_order_detail[<?php echo $service_row; ?>][amount]" value="<?php echo $detail['amount']; ?>" readonly="readonly" onchange="calcRowTotal('<?php echo $service_row; ?>','amount')"  />
                                                </td>
                                                <td>
                                                <a title="text_delete" href="javascript:void(0);" onclick="removeGridRow(<?php echo $service_row; ?>);"><span class="fa fa-times"></span></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <?php $service_row++; ?>
                                        <?php endforeach; ?>
                                        <tfoot>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-md-offset-9 col-md-3">
                                <div class="form-group">
                                    <label><?php echo $column_net_amount; ?></label>
                                    <input type="text" id="net_amount" name="net_amount" value="<?php echo $net_amount; ?>" class="form-control fDecimal" readonly="readonly" onchange="calcNetAmount('+ service_row +',\'net_amount\')" />
                                </div>
                            </div>
                        </div>

                    </form> 
                </div>
                    <div class="panel-heading heading">
                        &nbsp;
                        <ul style="float: right;" class="list-nostyle list-inline">
                            <li><a class="btn btn-outline btn-default btn-sm" href="<?php echo $cancel; ?>"><i class="fa fa-undo"></i><?php echo $button_cancel; ?></a></li>
                            <li><a class="btn btn-outline btn-primary btn-sm" href="javascript:void(0);" onclick="$('#form').submit();"><i class="fa fa-floppy-o"></i><?php echo $button_save; ?></a></li>
                        </ul>
                    </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	jQuery('.chosen').chosen();

    var service_row = '<?php echo $service_row; ?>';
    function addService() {
        html = '<tbody id="service_row_' + service_row + '" row_id="'+ service_row +'">';
        html +='<tr>';
        html +='<td><input  type="text" name="sale_order_detail['+service_row+'][product_code]" id="sale_order_detail_code_'+ service_row +'" class="" value="" onchange="getProductInformationCode('+ service_row +');" /></td>';
        html +='<td><div class="form-group input-group"><select class="" id="sale_order_detail_product_id_<?php echo $service_row; ?>" name="sale_order_detail['+service_row+'][product_id]" onchange="getProductInformation('+ service_row +');">';
        <?php foreach($products as $product): ?>
        html +='<option value="<?php echo $product['product_id']; ?>" ><?php echo $product['code'] . ': ' .$product['name']; ?></option>';   
        <?php endforeach; ?>
        html +='</select>';
        html +='<span class="input-group-btn ">';
        html +='<button type="button"  model="setup/product" ref_id="sale_order_detail_product_id_<?php echo $service_row; ?>" callback="getProductInformation" value="..." class="QSearch btn btn-default" ><i class="fa fa-search"></i>';
        html +='</button></span></div></td>';
        html +='<td><select class="" id="sale_order_detail_unit_id_' + service_row + '" name="sale_order_detail['+service_row+'][unit_id]">';
        <?php foreach($units as $unit): ?>
        html +='<option value="<?php echo $unit['unit_id']; ?>" ><?php echo $unit['name']; ?></option>';
        <?php endforeach; ?>	
        html +='</select></td>';
        html +='<td>';
        html +='<input type="text" class="fDecimal" id="sale_order_detail_qty_'+ service_row +'" name="sale_order_detail['+service_row+'][qty]" value="0" onchange="calcRowTotal('+ service_row +',\'qty\')" />';
        html +='</td>';
        html +='<td><input type="text" class="fDecimal" id="sale_order_detail_rate_'+ service_row +'" name="sale_order_detail['+service_row+'][rate]" value="0" onchange="calcRowTotal('+ service_row +',\'rate\')" /></td>';
        html +='<td><input type="text" class="fDecimal" id= "sale_order_detail_amount_'+ service_row +'" name="sale_order_detail['+service_row+'][amount]" value="0" onchange="calcRowTotal('+ service_row +',\'amount\')" readonly="readonly" /></td>';
        html +='<td><a href="javascript:void(0);" onclick="removeGridRow('+service_row+');"><span class="fa fa-times"></span></a></td>';
        html +='</tr>';
        html +='</tbody>';
        $('#sale_order thead').after(html);
        jQuery('.chosen').chosen();
        setFieldFormat();
        service_row++;

        addRowButton();
    };

    function getProductInformation(row_id){
        var element_product_id = '#sale_order_detail_product_id_' + row_id;
        var element_unit_id = ('#sale_order_detail_unit_id_' + row_id);
        var element_code = ('#sale_order_detail_code_' + row_id);
        var element_rate = ('#sale_order_detail_rate_' + row_id);
        //alert(element_product_id+'|'+row_id);
        $.ajax({
            url: '<?php echo HTTP_SERVER; ?>index.php?route=setup/product/getProductInformation&token=<?php echo $token; ?>',
            dataType: 'json',
            type: 'POST',
            data: 'product_id=' + $(element_product_id).val(),
            beforeSend: function() {
                $('#' + row_id).after('<span class="wait">&nbsp;<img src="view/image/loading.gif" alt="" /></span>');
            },
            complete: function() {
                $('.wait').remove();
            },
            success: function(json) {
                if(json.success) {
                    $(element_unit_id).html(json.unit).trigger("change");
                    $(element_code).val(json.code);
                    $(element_rate).val(json.rate);
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }


    function getProductInformationCode(row_id){
        var element_code = '#sale_order_detail_code_' + row_id;
        var element_product_id = ('#sale_order_detail_product_id_' + row_id);
        $.ajax({
            url: '<?php echo HTTP_SERVER; ?>index.php?route=setup/product/getProductInformationCode&token=<?php echo $token; ?>',
            dataType: 'json',
            type: 'POST',
            data: 'product_code=' + $(element_code).val(),
            beforeSend: function() {
                $('#' + row_id).after('<span class="wait">&nbsp;<img src="view/image/loading.gif" alt="" /></span>');
            },
            complete: function() {
                $('.wait').remove();
            },
            success: function(json) {
                if(json.success) {
                    $(element_product_id).val(json.product_id).trigger("change");
                    $(element_product_id).trigger('change');


                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }


    function addRowButton() {
        row_id = $('#sale_order tbody:last').attr('row_id');
        var btnAdd = '<a id="btnAddGrid" title="Add" href="javascript:void(0);" onclick="addService();"><span class="fa fa-plus"></span></a>';
        var btnRemove = '<a title="text_delete" href="javascript:void(0);" onclick="removeGridRow('+row_id+');"><span class="fa fa-times"></span></a>';
        $('#btnAddGrid').remove();
        if(row_id) {
            $('#sale_order tbody:last td:last').html(btnAdd+btnRemove);
            $('#sale_order tbody:last input:first').focus();
        } else {
            $('#sale_order thead td:last').html(btnAdd);
        }
    }

    function removeGridRow(grid_row) {
        $('#service_row_'+grid_row).remove();

        addRowButton();

    }


    function calcRowTotal(row_id, event) {
        var qty = 0 ;
        var rate = 0;
        var amount = 0;

        qty += parseFloat($('#sale_order_detail_qty_' + row_id).val());
        rate += parseFloat($('#sale_order_detail_rate_' + row_id).val());
        
        amount = qty*rate;
        $('#sale_order_detail_amount_' + row_id).val(amount);

        calcNetAmount();
    }
    
    function calcNetAmount() {
        var net_amount = 0;
        
        $('#sale_order tbody').each(function() {
            var row_id = $(this).attr('row_id');
            var amount = 0;
            net_amount += (parseFloat($('#sale_order_detail_amount_' + row_id).val()) || 0);
        });
        
        $('#net_amount').val(net_amount);
    }
    
    
</script>
<script type="text/javascript" src="view/js/plugins/validate/jquery.validate.min.js"></script>
<script>
    jQuery('#form').validate(<?php echo $strValidation; ?>);
</script>
<?php echo $footer; ?>