<!DOCTYPE html>
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.1.1/css/all.css" integrity="sha384-O8whS3fhG2OnA5Kas0Y9l3cfpmYjapjI0E4theH4iuMD+pLhbf6JI0jIMfYcK3yZ" crossorigin="anonymous">
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <!-- Main content -->
        <section class="content-header">
            <div class="row">
                <div class="col-sm-6">
                    <h1>Dashboard</h1>
                    <ol class="breadcrumb">
                        <li><a href="javascript:void();"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Dashboard</li>
                    </ol>

                </div>
            </div>
        </section>

        <section class="content">
        <!-- Info boxes -->
        <div class="row">
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['revenue']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_revenue,2); ?><small></small></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['expense']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_expense,2); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- fix for small devices only -->
            <div class="clearfix visible-sm-block"></div>

            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-money"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['profit']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_profit,2); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-briefcase"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['asset']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_asset,2); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
        </div>

        <div class="row">
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-balance-scale"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['liability']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_liability,2); ?><small></small></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fas fa-hand-holding-usd"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['equity']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_equity,2); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- fix for small devices only -->
            <div class="clearfix visible-sm-block"></div>

            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-tags"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['total_product_category']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_product_category); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-tag"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo $lang['total_product']; ?></span>
                        <span class="info-box-number"><?php echo number_format($total_products); ?></span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-4">

                    <!-- TABLE: PRODUCT CATEGORY IN WAREHOUSE -->
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $lang['category_wise_stock']; ?></h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                <!--<button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>-->
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table no-margin">
                                    <thead>
                                    <tr>
                                        <th><?php echo $lang['product_category']; ?></th>
                                        <th><?php echo $lang['warehouse']; ?></th>
                                        <th><?php echo $lang['total_cft']; ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($total_product_category_in_warehouse as $rows): ?>
                                    <tr>
                                        <td><?php echo $rows['product_category']; ?></td>
                                        <td><?php echo $rows['warehouse']; ?></td>
                                        <td><?php echo $rows['SUM(base_cubic_feet)']; ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                    </div>
                    <div class="col-md-4">

                    <!-- TABLE: SUPPLIER BALANCE-->
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $lang['supplier_balance']; ?></h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                <!--<button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>-->
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table no-margin">
                                    <thead>
                                    <tr>
                                        <th><?php echo $lang['supplier']; ?></th>
                                        <th><?php echo $lang['balance']; ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($get_supplier_balance as $rows): ?>
                                    <tr>
                                        <td><?php echo $rows['supplier_name']; ?></td>
                                        <?php if($rows['balance'] < 0):?>
                                        <td style="text-align: right;">CR <?php echo number_format(-1*$rows['balance'], 2); ?></td>
                                        <?php else: ?>
                                        <td style="text-align: right;">DR <?php echo number_format($rows['balance'], 2); ?></td>
                                        <?php endif;?>
                                    </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                    </div>
                    <div class="col-md-4">

                    <!-- TABLE: CUSTOMER BALANCE-->
                    <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $lang['customer_balance']; ?></h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                <!--<button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>-->
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table no-margin">
                                    <thead>
                                    <tr>
                                        <th><?php echo $lang['customer']; ?></th>
                                        <th><?php echo $lang['balance']; ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($get_customer_balance as $rows): ?>
                                    <tr>
                                        <td><?php echo $rows['customer_name']; ?></td>
                                        <?php if($rows['balance'] < 0):?>
                                        <td style="text-align: right;">CR <?php echo number_format(-1*$rows['balance'], 2); ?></td>
                                        <?php else: ?>
                                        <td style="text-align: right;">DR <?php echo number_format($rows['balance'], 2); ?></td>
                                        <?php endif;?>
                                    </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
        </section>
    </div>

    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>