<?php

class ControllerReportTrialBalance extends HController {

    protected function getAlias() {
        return 'report/trial_balance';
    }

    protected function getList() {
        parent::getList();

        $this->model['company_branch'] = $this->load->model('setup/company_branch');
        $this->model['user_branch_access'] = $this->load->model('user/user_branch_access');

        $branches = $this->model['company_branch']->getArrays('company_branch_id', 'name');
        $user_branches = $this->model['user_branch_access']->getRows(array('user_id' => $this->session->data['user_id']));
        foreach($user_branches as $branch) {
            $this->data['branches'][] = array(
                'company_branch_id' => $branch['company_branch_id'],
                'branch_name' => $branches[$branch['company_branch_id']]
            );
        }
        $this->data['company_branch_id'] = $this->session->data['company_branch_id'];
        $this->data['date_to'] = stdDate();
        $this->data['action_print'] = $this->url->link($this->getAlias() .'/printReport', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function printReport() {
        $this->init();

        $lang = $this->load->language($this->getAlias());
        $post = $this->request->post;
        $session = $this->session->data;

        $arrFilter['to_date'] = $post['date_to'];
        $arrFilter['level'] = $post['level'];

        $this->model['user_branch_access'] = $this->load->model('user/user_branch_access');
        $user_branches = $this->model['user_branch_access']->getArrays('company_branch_id','company_branch_id',array('user_id' => $this->session->data['user_id']));

        $this->model['trial_balance'] = $this->load->model('report/trial_balance');
        $where = "l.company_id='".$this->session->data['company_id']."'";
        if($post['company_branch_id']=='') {
            $where .= " AND l.company_branch_id IN (".implode(',',$user_branches).")";
        } else {
            $where .= " AND l.company_branch_id='".$post['company_branch_id']."'";
        }
        $where .= " AND l.fiscal_year_id='".$this->session->data['fiscal_year_id']."'";
        $where .= " AND l.document_date<='".MySqlDate($this->request->post['date_to'])."'";
        $rows = $this->model['trial_balance']->getTrialBalance($where,array('level1_code,level2_code,level3_code'));
        //d($rows);
        foreach($rows as $row){
            $arrRows[$row['level1_display_name']][$row['level2_display_name']][] = array(
                'level3_display_name' => $row['level3_display_name'],
                'debit' => round(($row['balance'] > 0 ? $row['balance'] : 0),2),
                'credit' => round(($row['balance'] < 0 ? (-1 * $row['balance']) : 0),2)
            );
        }
        //d(array($this->request->post,$where,$rows,$arrRows),true);

        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));
        $company_logo = $setting['value'];

        //d($arrLedger, true);
        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Trial Balance');
        $pdf->SetSubject('Trial Balance');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => $lang['heading_title'],
            'company_logo' => $session['company_image'],
            'filter' => $arrFilter
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 35, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set font
        $pdf->SetFont('times', '', 12);

        // add a page
        $pdf->AddPage();
        $total_debit = 0;
        $total_credit = 0;
        $pdf->Cell(130,10,'Accounts',1,0,'C',0);
        $pdf->Cell(30,10,'Debit',1,0,'C',0);
        $pdf->Cell(30,10,'Credit',1,0,'C',0);
        foreach($arrRows as $level1_display_name => $level2) {
            if($post['display_level'] > 1) {
                $pdf->ln(10);
                //$pdf->SetFillColor(25,25,255);
                $pdf->Cell(0,10,$level1_display_name,0,0,'',0);
            }
            $level1_debit=0;
            $level1_credit=0;

            foreach($level2 as $level2_display_name => $level3) {
                if($post['display_level']==3) {
                    $pdf->ln(10);
                    //$pdf->SetFillColor(25,25,255);
                    $pdf->Cell(5,10,'',0,0,'',0);
                    //$pdf->SetFillColor(102,102,255);
                    $pdf->Cell(175,10,$level2_display_name,0,0,'L',0);
                }
                $level2_debit = 0;
                $level2_credit = 0;
                foreach($level3 as $record) {
                    if($post['display_level']==3) {
                        $pdf->ln(7);
                        $pdf->SetFillColor(211,211,211);
                        $pdf->Cell(5,7,'',0,0,'',0);
                        //$pdf->SetFillColor(102,102,255);
                        $pdf->Cell(5,7,'',0,0,'',0);
                        //$pdf->SetFillColor(178,178,255);
                        $pdf->Cell(100,7,$record['level3_display_name'],0,0,'L',1,'',1);
                        $pdf->Cell(30,7,number_format($record['debit'],2),0,0,'R',1);
                        $pdf->Cell(30,7,number_format($record['credit'],2),0,0,'R',1);
                    }
                    $level2_debit += $record['debit'];
                    $level2_credit += $record['credit'];

                    $total_debit += $record['debit'];
                    $total_credit += $record['credit'];
                }
                if($post['display_level'] > 1) {
                    $pdf->ln(7);
                    //$pdf->SetFillColor(25,25,255);
                    $pdf->Cell(5,7,'',0,0,'',0);
                    //$pdf->SetFillColor(102,102,255);
                    $pdf->Cell(125,7,$level2_display_name,0,0,'L',0);
                    $pdf->Cell(30,7,number_format($level2_debit,2),0,0,'R',0);
                    $pdf->Cell(30,7,number_format($level2_credit,2),0,0,'R',0);
                }

                $level1_debit += $level2_debit;
                $level1_credit += $level2_credit;
            }
            $pdf->ln(10);
            //$pdf->SetFillColor(25,25,255);
            $pdf->Cell(130,10,$level1_display_name,'B',0,'L',0);
            $pdf->Cell(30,10,number_format($level1_debit,2),'TB',0,'R',0);
            $pdf->Cell(30,10,number_format($level1_credit,2),'TB',0,'R',0);
        }
        $pdf->ln(20);
        //$pdf->SetFillColor(255,255,255);
        $pdf->Cell(130,10,'Total',0,0,'R',0);
        $pdf->Cell(30,10,number_format($total_debit,2),0,0,'R',0);
        $pdf->Cell(30,10,number_format($total_credit,2),0,0,'R',0);

        //Close and output PDF document
        $pdf->Output('Trial Balance:'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $data = array();

    //Page header
    public function Header() {
        // Logo
//        if($this->data['company_logo'] != '') {
//            $image_file = DIR_IMAGE."Logo WBA.png";
//            //$this->Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false);
//            $this->Image($image_file, 10, 10, 30, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//        }

        $image_file = DIR_IMAGE . "Logo WBA.png";
        $this->Image($image_file, 170, 8, 32, 10, '', '', 'R', false, 300, '', false, false, 1, false, false, false);

        // Set font
        $this->SetFont('helvetica', 'B', 20);
        $this->Ln(2);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->Cell(0, 10, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(7);
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(0, 10, 'As on '.$this->data['filter']['to_date'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

?>