<?php

class ControllerReportStock extends HController {

    protected function getAlias() {
        return 'report/stock';
    }

    protected function init() {
        $this->model['stock'] = $this->load->model('common/stock_ledger');
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();

        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->data['warehouses'] = $this->model['warehouse']->getRows(array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));

        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $this->data['product_categories'] = $this->model['product_category']->getRows(array('company_id' => $this->session->data['company_id']));

        //$this->model['product'] = $this->load->model('inventory/product');
        //$this->data['products'] = $this->model['product']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['action_validate_date'] = $this->url->link('common/home/validateDate', 'token=' . $this->session->data['token']);
        $this->data['date_from'] = stdDate($this->session->data['fiscal_date_from']);
        $this->data['date_to'] = stdDate(($this->session->data['fiscal_date_to'] > date('Y-m-d') ? '' : $this->session->data['fiscal_date_to']));

        $this->data['strValidation'] = "{
                'rules': {
                    'date_from': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                    'date_to': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                },
            }";

        $this->data['href_get_product_json'] = $this->url->link($this->getAlias() . '/getProductJson', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_detail_report'] = $this->url->link($this->getAlias() .'/getDetailReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_summary_report'] = $this->url->link($this->getAlias() .'/getSummaryReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_warehouse_detail'] = $this->url->link($this->getAlias() .'/printWarehouseDetail', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_warehouse_summary'] = $this->url->link($this->getAlias() .'/printWarehouseSummary', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_container_detail'] = $this->url->link($this->getAlias() .'/printContainerDetail', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_print_container_summary'] = $this->url->link($this->getAlias() .'/printContainerSummary', 'token=' . $this->session->data['token'], 'SSL');

        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getProductJson() {
        $search = $this->request->post['q'];
        $page = $this->request->post['page'];
        $product_category_id = $this->request->post['product_category_id'];

        $this->model['product'] = $this->load->model('inventory/product');
        $rows = $this->model['product']->getProductJson($search, $page, 25, array('product_category_id' => $product_category_id));

        echo json_encode($rows);
    }

    public function getDetailReport() {
        ini_set('max_execution_time','0');
        ini_set("memory_limit","256M");
        $post = $this->request->post;
        $session = $this->session->data;
        $this->model['stock'] = $this->load->model('common/stock_ledger');
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$session['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$session['fiscal_year_id']."'";
        if($post['date_from'] != '') {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
        }
        if($post['date_to'] != '') {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
        }
        if($post['warehouse_id'])
            $arrWhere[] = "`warehouse_id` = '" . $post['warehouse_id'] . "'";
        if($post['product_id'])
            $arrWhere[] = "`product_id` = '" . $post['product_id'] . "'";

        $where = implode(' AND ', $arrWhere);
        $rows = $this->model['stock']->getRows($where);
        $html = '';
        foreach($rows as $row) {
            $html .= '<tr>';
            $html .= '<td>'.stdDate($row['document_date']).'</td>';
            $html .= '<td>'.$row['document_identity'].'</td>';
            $html .= '<td>'.$row['warehouse'].'</td>';
            $html .= '<td>'.$row['product_category'].'</td>';
            $html .= '<td>'.$row['product_code'].'</td>';
            $html .= '<td>'.$row['product_name'].'</td>';
            $html .= '<td>'.$row['base_unit'].'</td>';
            $html .= '<td>'.$row['base_qty'].'</td>';
            $html .= '<td>'.$row['base_rate'].'</td>';
            $html .= '<td>'.$row['base_amount'].'</td>';
            $html .= '</tr>';
        }

        $json = array(
            'success' => true,
            'post' => $post,
            'html' => $html,
            'rows' => $rows
        );
        //d($json,true);
        $this->response->setOutput(json_encode($json));
    }

    public function printWarehouseDetail() {
        ini_set('max_execution_time',400);
        ini_set('memory_limit','1024M');
        $lang = $this->load->language($this->getAlias());

        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['stock'] = $this->load->model('common/stock_ledger');

        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $arrWarehouses = $this->model['warehouse']->getArrays('warehouse_id','name',array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));
        $arrProductCategories = $this->model['product_category']->getArrays('product_category_id','name',array('company_id' => $this->session->data['company_id']));
        $arrProducts = $this->model['product']->getArrays('product_id','name',array('company_id' => $this->session->data['company_id']));

        $arrWhere = array();
        $filter = array();
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$session['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$session['fiscal_year_id']."'";
        if($post['date_from'] != '') {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
            $filter['date_from'] = $post['date_from'];
        }
        if($post['date_to'] != '') {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
            $filter['date_to'] = $post['date_to'];
        }
        if($post['warehouse_id']) {
            $arrWhere[] = "`warehouse_id` = '" . $post['warehouse_id'] . "'";
            $filter['warehouse'] = $arrWarehouses[$post['warehouse_id']];
        }
        if($post['product_category_id']) {
            $arrWhere[] = "`product_category_id` = '" . $post['product_category_id'] . "'";
            $filter['product_category'] = $arrProductCategories[$post['product_category_id']];
        }
        if($post['product_id']) {
            $arrWhere[] = "`product_id` = '" . $post['product_id'] . "'";
            $filter['product'] = $arrProducts[$post['product_id']];
        }
        if($post['container_no']) {
            $arrWhere[] = "`container_no` LIKE '%" . $post['container_no'] . "%'";
            $filter['container_no'] = $post['container_no'];
        }

        $where = implode(' AND ', $arrWhere);

        $rows = $this->model['stock']->getRows($where, array('document_date', 'created_at', 'batch_no'));
        $stocks = array();
        foreach($rows as $row) {
            $stocks[$row['warehouse']][$row['product_code'] . ' - ' . $row['product_name']][] = array(
                'container_no' => $row['container_no'],
                'batch_no' => $row['batch_no'],
                'product_code' => $row['product_code'],
                'document_date' => stdDate($row['document_date']),
                'document_identity' => $row['document_identity'],
                'total_cubic_meter' => $row['base_cubic_meter'],
                'total_cubic_feet' => $row['base_cubic_feet'],
                'qty' => $row['base_qty'],
                'rate' => $row['base_rate'],
                'amount' => $row['base_amount'],
                'created_at' => $row['created_at']
            );
        }

        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));

        //$company_logo = $this->model['image']->resize($setting['value'],200,50);
        $company_logo = $setting['value'];

        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Stock Ledger');
        $pdf->SetSubject('Stock Ledger');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => $lang['heading_title'],
            'company_logo' => $company_logo,
            'filter' => $filter
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 40, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        //d($stocks, true);
        $pdf->AddPage();
        foreach($stocks as $warehouse => $products) {
            foreach($products as $product_name => $rows) {
                // set font
                $pdf->SetFont('times', 'B', 8);
                // add a page
                $pdf->Cell(0, 10, 'Warehouse: ' . $warehouse, 0, false, 'L');
                $pdf->Ln(5);
                $pdf->Cell(100, 10, 'Product: ' . $product_name, 0, false, 'L');
                $pdf->Ln(15);
                $pdf->Cell(7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['document_date'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 10, $lang['document_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(35, 10, $lang['container_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(35, 10, $lang['batch_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['rate'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(25, 10, $lang['created_at'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Ln(2);

                $sr =0;
                $balance_qty = 0;
                $balance_cubic_meter = 0;
                $balance_cubic_feet = 0;
                $balance_amount = 0;
                foreach($rows as $detail) {
                    $balance_qty += $detail['qty'];
                    $balance_cubic_meter += $detail['total_cubic_meter'];
                    $balance_cubic_feet += $detail['total_cubic_feet'];
                    $balance_amount += $detail['amount'];
                    $avg_rate = ($balance_amount / $balance_cubic_feet);

                    // set font
                    $pdf->SetFont('times', '', 8);
                    $sr++;
                    $pdf->Ln(7);
                    $pdf->Cell(7, 7, $sr, 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, $detail['document_date'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $detail['document_identity'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(35, 7, $detail['container_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(35, 7, $detail['batch_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(15, 7, number_format($detail['qty'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['total_cubic_meter'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['total_cubic_feet'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['rate'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, number_format($detail['amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(25, 7, stdDateTime($detail['created_at']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                }
                // set font
                $pdf->SetFont('times', 'B', 8);
                $pdf->Ln(7);
                $pdf->Cell(127, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, number_format($balance_qty,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($balance_cubic_meter,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($balance_cubic_feet,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, 'Avg. '.number_format($avg_rate,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, number_format($balance_amount,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Ln(7);
            }
        }

        //Close and output PDF document
        $pdf->Output('Stock Ledger:'.date('YmdHis').'.pdf', 'I');
    }

    public function printContainerDetail() {
        ini_set('max_execution_time',400);
        ini_set('memory_limit','1024M');
        $lang = $this->load->language($this->getAlias());

        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['stock'] = $this->load->model('common/stock_ledger');

        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $arrWarehouses = $this->model['warehouse']->getArrays('warehouse_id','name',array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));
        $arrProductCategories = $this->model['product_category']->getArrays('product_category_id','name',array('company_id' => $this->session->data['company_id']));
        $arrProducts = $this->model['product']->getArrays('product_id','name',array('company_id' => $this->session->data['company_id']));

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$session['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$session['fiscal_year_id']."'";
        if($post['date_from'] != '') {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
            $filter['date_from'] = $post['date_from'];
        }
        if($post['date_to'] != '') {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
            $filter['date_to'] = $post['date_to'];
        }
        if($post['warehouse_id']) {
            $arrWhere[] = "`warehouse_id` = '" . $post['warehouse_id'] . "'";
            $filter['warehouse'] = $arrWarehouses[$post['warehouse_id']];
        }
        if($post['product_category_id']) {
            $arrWhere[] = "`product_category_id` = '" . $post['product_category_id'] . "'";
            $filter['product_category'] = $arrProductCategories[$post['product_category_id']];
        }
        if($post['product_id']) {
            $arrWhere[] = "`product_id` = '" . $post['product_id'] . "'";
            $filter['product'] = $arrProducts[$post['product_id']];
        }
        if($post['container_no']) {
            $arrWhere[] = "`container_no` LIKE '%" . $post['container_no'] . "%'";
            $filter['container_no'] = $post['container_no'];
        }

        //d(array($post, $filter), true);

        $where = implode(' AND ', $arrWhere);

        $rows = $this->model['stock']->getRows($where, array('document_date', 'created_at', 'batch_no'));
        $stocks = array();
        foreach($rows as $row) {
            $stocks[$row['container_no']][$row['product_code'] . ' - ' . $row['product_name']][] = array(
                'warehouse' => $row['warehouse'],
                'batch_no' => $row['batch_no'],
                'product_code' => $row['product_code'],
                'document_date' => stdDate($row['document_date']),
                'document_identity' => $row['document_identity'],
                'total_cubic_meter' => $row['base_cubic_meter'],
                'total_cubic_feet' => $row['base_cubic_feet'],
                'qty' => $row['base_qty'],
                'rate' => $row['base_rate'],
                'amount' => $row['base_amount'],
                'created_at' => $row['created_at']
            );
        }

        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));

        //$company_logo = $this->model['image']->resize($setting['value'],200,50);
        $company_logo = $setting['value'];

        $pdf = new PDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Stock Ledger');
        $pdf->SetSubject('Stock Ledger');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => $lang['heading_title'],
            'company_logo' => $company_logo,
            'filter' => $filter
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 40, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        //d($stocks, true);
        // add a page
        $pdf->AddPage();
        foreach($stocks as $container_no => $products) {
            foreach($products as $product_name => $rows) {
                // set font
                $pdf->SetFont('times', 'B', 8);
                $pdf->Cell(0, 10, 'Container No: ' . $container_no, 0, false, 'L');
                $pdf->Ln(5);
                $pdf->Cell(100, 10, 'Product: ' . $product_name, 0, false, 'L');
                $pdf->Ln(15);
                $pdf->Cell(7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['document_date'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 10, $lang['document_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(35, 10, $lang['warehouse'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(35, 10, $lang['batch_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(20, 10, $lang['rate'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(30, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(25, 10, $lang['created_at'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Ln(2);

                $sr =0;
                $balance_qty = 0;
                $balance_cubic_meter = 0;
                $balance_cubic_feet = 0;
                $balance_amount = 0;
                foreach($rows as $detail) {
                    $balance_qty += $detail['qty'];
                    $balance_cubic_meter += ($detail['total_cubic_meter']);
                    $balance_cubic_feet += ($detail['total_cubic_feet']);
                    $balance_amount += $detail['amount'];
                    $avg_rate = ($balance_amount / $balance_cubic_feet);

                    // set font
                    $pdf->SetFont('times', '', 8);
                    $sr++;
                    $pdf->Ln(7);
                    $pdf->Cell(7, 7, $sr, 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, $detail['document_date'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, $detail['document_identity'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(35, 7, $detail['warehouse'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(35, 7, $detail['batch_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(15, 7, number_format($detail['qty'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['total_cubic_meter'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['total_cubic_feet'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(20, 7, number_format($detail['rate'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(30, 7, number_format($detail['amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(25, 7, stdDateTime($detail['created_at']), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    //d(array($balance_cubic_meter, $detail['total_cubic_meter']));
                }
                // set font
                $pdf->SetFont('times', 'B', 8);
                $pdf->Ln(7);
                $pdf->Cell(127, 7, '', 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(15, 7, number_format($balance_qty,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($balance_cubic_meter,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, number_format($balance_cubic_feet,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(20, 7, 'Avg. '.number_format($avg_rate,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(30, 7, number_format($balance_amount,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Ln(7);
            }
        }

        //Close and output PDF document
        $pdf->Output('Stock Ledger:'.date('YmdHis').'.pdf', 'I');
    }

    public function printWarehouseSummary() {
        ini_set('max_execution_time',400);
        ini_set('memory_limit','1024M');
        $lang = $this->load->language($this->getAlias());

        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['stock'] = $this->load->model('common/stock_ledger');

        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $arrWarehouses = $this->model['warehouse']->getArrays('warehouse_id','name',array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));
        $arrProductCategories = $this->model['product_category']->getArrays('product_category_id','name',array('company_id' => $this->session->data['company_id']));
        $arrProducts = $this->model['product']->getArrays('product_id','name',array('company_id' => $this->session->data['company_id']));

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$session['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$session['fiscal_year_id']."'";
        if($post['date_from'] != '') {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
            $filter['date_from'] = $post['date_from'];
        }
        if($post['date_to'] != '') {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
            $filter['date_to'] = $post['date_to'];
        }
        if($post['warehouse_id']) {
            $arrWhere[] = "`warehouse_id` = '" . $post['warehouse_id'] . "'";
            $filter['warehouse'] = $arrWarehouses[$post['warehouse_id']];
        }
        if($post['product_category_id']) {
            $arrWhere[] = "`product_category_id` = '" . $post['product_category_id'] . "'";
            $filter['product_category'] = $arrProductCategories[$post['product_category_id']];
        }
        if($post['product_id']) {
            $arrWhere[] = "`product_id` = '" . $post['product_id'] . "'";
            $filter['product'] = $arrProducts[$post['product_id']];
        }
        if($post['container_no']) {
            $arrWhere[] = "`container_no` = '" . $post['container_no'] . "'";
            $filter['container_no'] = $post['container_no'];
        }
        $where = implode(' AND ', $arrWhere);

        $rows = $this->model['stock']->getRows($where, array('document_date', 'created_at', 'batch_no','product_code'));
        $stocks = array();
        foreach($rows as $row) {
            if(!isset($stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']])) {
                $stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']] = array(
                    'warehouse' => $row['warehouse'],
                    'container_no' => $row['container_no'],
                    'batch_no' => $row['batch_no'],
                    'product_code' => $row['product_code'],
                    'product_name' => $row['product_name'],
                    'total_qty' => 0,
                    'total_cubic_meter' => 0,
                    'total_cubic_feet' => 0,
                    'total_amount' => 0,
                );
            }

            $stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_qty'] += $row['base_qty'];
            $stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_cubic_meter'] += $row['base_cubic_meter'];
            $stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_cubic_feet'] += $row['base_cubic_feet'];
            $stocks[$row['warehouse']][$row['container_no'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_amount'] += $row['base_amount'];
        }
        //d($stocks, true);
        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));

        //$company_logo = $this->model['image']->resize($setting['value'],200,50);
        $company_logo = $setting['value'];

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Stock Ledger');
        $pdf->SetSubject('Stock Ledger');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Product Summary',
            'company_logo' => $company_logo,
            'filter' => $filter
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 35, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();

        $sr =0;
        foreach($stocks as $warehouse => $products) {
            // set font
            $pdf->SetFont('times', 'B', 8);
            $balance_qty = 0;
            $balance_cubic_meter = 0;
            $balance_cubic_feet = 0;
            $balance_amount = 0;
            $pdf->Ln(7);
            $pdf->Cell(200, 7, 'Warehouse: ' . $warehouse, 0, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Ln(7);
            $pdf->Cell(7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 10, $lang['container_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(15, 10, $lang['batch_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(85, 10, $lang['product'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(13, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(13, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(13, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(13, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(13, 10, $lang['avg_cost'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Ln(2);
            // set font
            $pdf->SetFont('times', '', 8);
            foreach($products as $detail) {
                if($detail['total_qty'] != 0) {
                    $balance_qty += $detail['total_qty'];
                    $balance_cubic_meter += $detail['total_cubic_meter'];
                    $balance_cubic_feet += $detail['total_cubic_feet'];
                    $balance_amount += $detail['total_amount'];
                    $sr++;
                    $pdf->Ln(7);
                    $pdf->Cell(7, 7, $sr, 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(15, 7, $detail['container_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(15, 7, $detail['batch_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(85, 7, $detail['product_code'] . ' - ' . $detail['product_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(13, 7, number_format($detail['total_qty'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(13, 7, number_format($detail['total_cubic_meter'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(13, 7, number_format($detail['total_cubic_feet'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(13, 7, number_format($detail['total_amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    $pdf->Cell(13, 7, number_format(($detail['total_amount']/$detail['total_cubic_feet']),2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                }
            }
            // set font
            $pdf->SetFont('times', 'B', 8);
            $pdf->Ln(7);
            $pdf->Cell(122, 7, '', 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(13, 7, number_format($balance_qty,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(13, 7, number_format($balance_cubic_meter,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(13, 7, number_format($balance_cubic_feet,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(13, 7, number_format($balance_amount,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Ln(7);
        }

        //Close and output PDF document
        $pdf->Output('Stock Summary:'.date('YmdHis').'.pdf', 'I');
    }

    public function printContainerSummary() {
        ini_set('max_execution_time',400);
        ini_set('memory_limit','1024M');
        $lang = $this->load->language($this->getAlias());

        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['warehouse'] = $this->load->model('setup/warehouse');
        $this->model['product_category'] = $this->load->model('inventory/product_category');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['product'] = $this->load->model('inventory/product');
        $this->model['stock'] = $this->load->model('common/stock_ledger');

        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $arrWarehouses = $this->model['warehouse']->getArrays('warehouse_id','name',array('company_id' => $this->session->data['company_id'], 'company_branch_id' => $this->session->data['company_branch_id']));
        $arrProductCategories = $this->model['product_category']->getArrays('product_category_id','name',array('company_id' => $this->session->data['company_id']));
        $arrProducts = $this->model['product']->getArrays('product_id','name',array('company_id' => $this->session->data['company_id']));

        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$session['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$session['company_branch_id']."'";
        $arrWhere[] = "`fiscal_year_id` = '".$session['fiscal_year_id']."'";
        if($post['date_from'] != '') {
            $arrWhere[] = "`document_date` >= '".MySqlDate($post['date_from'])."'";
            $filter['date_from'] = $post['date_from'];
        }
        if($post['date_to'] != '') {
            $arrWhere[] = "`document_date` <= '".MySqlDate($post['date_to'])."'";
            $filter['date_to'] = $post['date_to'];
        }
        if($post['warehouse_id']) {
            $arrWhere[] = "`warehouse_id` = '" . $post['warehouse_id'] . "'";
            $filter['warehouse'] = $arrWarehouses[$post['warehouse_id']];
        }
        if($post['product_category_id']) {
            $arrWhere[] = "`product_category_id` = '" . $post['product_category_id'] . "'";
            $filter['product_category'] = $arrProductCategories[$post['product_category_id']];
        }
        if($post['product_id']) {
            $arrWhere[] = "`product_id` = '" . $post['product_id'] . "'";
            $filter['product'] = $arrProducts[$post['product_id']];
        }
        if($post['container_no']) {
            $arrWhere[] = "`container_no` = '" . $post['container_no'] . "'";
            $filter['container_no'] = $post['container_no'];
        }
        $where = implode(' AND ', $arrWhere);

        $rows = $this->model['stock']->getRows($where, array('document_date', 'created_at', 'batch_no','product_code'));
        //d($rows, true);
        $stocks = array();
        foreach($rows as $row) {
            if(!isset($stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']])) {
                $stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']] = array(
                    'warehouse' => $row['warehouse'],
                    'container_no' => $row['container_no'],
                    'batch_no' => $row['batch_no'],
                    'product_code' => $row['product_code'],
                    'product_name' => $row['product_name'],
                    'total_qty' => 0,
                    'total_cubic_meter' => 0,
                    'total_cubic_feet' => 0,
                    'total_amount' => 0,
                );
            }

            $stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_qty'] += $row['base_qty'];
            $stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_cubic_meter'] += $row['base_cubic_meter'];
            $stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_cubic_feet'] += $row['base_cubic_feet'];
            $stocks[$row['container_no']][$row['warehouse'].'-'.$row['batch_no'].'-'.$row['product_id']]['total_amount'] += $row['base_amount'];
        }
        //d($stocks, true);
        $this->model['image'] = $this->load->model('tool/image');
        $this->model['setting'] = $this->load->model('common/setting');
        $setting = $this->model['setting']->getRow(array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'general',
            'field' => 'company_logo',
        ));

        //$company_logo = $this->model['image']->resize($setting['value'],200,50);
        $company_logo = $setting['value'];

        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Huzaifa Khambaty');
        $pdf->SetTitle('Stock Ledger');
        $pdf->SetSubject('Stock Ledger');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'report_name' => 'Product Summary',
            'company_logo' => $company_logo,
            'filter' => $filter
        );

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetMargins(15, 35, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // add a page
        $pdf->AddPage();

        $sr =0;
        $arrSummary = array();
        foreach($stocks as $container_no => $products) {
            if(count($products) > 0) {
                $balance_qty = 0;
                $balance_cubic_meter = 0;
                $balance_cubic_feet = 0;
                $balance_amount = 0;

                $cp = $pdf->getPage();
                $pdf->startTransaction();

                // set font
                $pdf->SetFont('times', 'B', 8);
                $pdf->Ln(7);
                $pdf->Cell(200, 7, 'Container: ' . $container_no, 0, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Ln(7);
                $pdf->Cell(7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 10, $lang['warehouse'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(15, 10, $lang['batch_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(85, 10, $lang['product'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(13, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(13, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(13, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(13, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Cell(13, 10, $lang['avg_cost'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                $pdf->Ln(2);
                if($pdf->getPage() > $cp) {
                    $pdf->rollbackTransaction(true);//true is very important
                    $pdf->AddPage();

                    // set font
                    $pdf->SetFont('times', 'B', 8);
                    $pdf->Ln(7);
                    $pdf->Cell(200, 7, 'Container: ' . $container_no, 0, false, 'L', 0, '', 1, false, 'M', 'M');
                    $pdf->Ln(7);
                    $pdf->Cell(7, 10, 'Sr.', 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(15, 10, $lang['warehouse'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(15, 10, $lang['batch_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(85, 10, $lang['product'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(13, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(13, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(13, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(13, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Cell(13, 10, $lang['avg_cost'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
                    $pdf->Ln(2);
                } else {
                    $pdf->commitTransaction();
                }
                // set font
                $pdf->SetFont('times', '', 8);
                foreach($products as $detail) {
                    if($detail['total_qty'] != 0) {
                        $balance_qty += $detail['total_qty'];
                        $balance_cubic_meter += $detail['total_cubic_meter'];
                        $balance_cubic_feet += $detail['total_cubic_feet'];
                        $balance_amount += $detail['total_amount'];
                        $sr++;
                        $pdf->Ln(7);
                        $pdf->Cell(7, 7, $sr, 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(15, 7, $detail['warehouse'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(15, 7, $detail['batch_no'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(85, 7, $detail['product_code'] . ' - ' . $detail['product_name'], 1, false, 'L', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(13, 7, number_format($detail['total_qty'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(13, 7, number_format($detail['total_cubic_meter'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(13, 7, number_format($detail['total_cubic_feet'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(13, 7, number_format($detail['total_amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                        $pdf->Cell(13, 7, number_format(($detail['total_amount']/$detail['total_cubic_feet']),2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                    }
                }
                // set font
                $pdf->SetFont('times', 'B', 8);
                $pdf->Ln(7);
                $pdf->Cell(122, 7, '', 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(13, 7, number_format($balance_qty,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(13, 7, number_format($balance_cubic_meter,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(13, 7, number_format($balance_cubic_feet,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(13, 7, number_format($balance_amount,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Ln(7);

                $arrSummary[$container_no] = array(
                    'total_quantity' => $balance_qty,
                    'total_meter' => $balance_cubic_meter,
                    'total_feet' => $balance_cubic_feet,
                    'total_amount' => $balance_amount
                );
            }
        }

        if($arrSummary) {
            $pdf->AddPage();

            // set font
            $pdf->SetFont('times', 'B', 8);
            $pdf->Ln(7);
            $pdf->Cell(140, 10, 'Container Wise Summary', 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Ln(11);
            $pdf->Cell(40, 10, $lang['container_no'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 10, $lang['qty'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 10, $lang['cubic_meter'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 10, $lang['cubic_feet'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Cell(25, 10, $lang['amount'], 1, false, 'C', 0, '', 0, false, 'M', 'M');
            $pdf->Ln(2);

            $pdf->SetFont('times', '', 8);
            $total_quantity = 0;
            $total_meter = 0;
            $total_feet = 0;
            $total_amount = 0;
            foreach($arrSummary as $container_no => $summary) {
                $pdf->Ln(7);
                $pdf->Cell(40, 7, $container_no, 1, false, 'L', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, number_format($summary['total_quantity'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, number_format($summary['total_meter'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, number_format($summary['total_feet'],4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
                $pdf->Cell(25, 7, number_format($summary['total_amount'],2), 1, false, 'R', 0, '', 1, false, 'M', 'M');

                $total_quantity += $summary['total_quantity'];
                $total_meter += $summary['total_meter'];
                $total_feet += $summary['total_feet'];
                $total_amount += $summary['total_amount'];
            }
            $pdf->SetFont('times', 'B', 8);
            $pdf->Ln(7);
            $pdf->Cell(40, 7, '', 1, false, 'L', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, number_format($total_quantity,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, number_format($total_meter,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, number_format($total_feet,4), 1, false, 'R', 0, '', 1, false, 'M', 'M');
            $pdf->Cell(25, 7, number_format($total_amount,2), 1, false, 'R', 0, '', 1, false, 'M', 'M');

        }
        //Close and output PDF document
        $pdf->Output('Stock Summary:'.date('YmdHis').'.pdf', 'I');
    }
}

class PDF extends TCPDF {
    public $data = array();

    //Page header
    public function Header() {
        // Logo
        if($this->data['company_logo'] != '') {
            $image_file = DIR_IMAGE.$this->data['company_logo'];
            //$this->Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false);
            $this->Image($image_file, 10, 10, 30, '', '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        $this->Ln(2);
        // Title
        $this->Cell(0, 10, $this->data['company_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(10);
        $this->Cell(0, 10, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(7);
        $this->SetFont('helvetica', '', 10);
        $this->Cell(0, 10, 'As on '.$this->data['filter']['date_to'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

?>