<?php

class ControllerReportDeliveryChallanReport extends HController {

    protected function getAlias() {
        return 'report/delivery_challan_report';
    }
    
    protected function getDefaultOrder() {
        return 'delivery_challan_id';
    }

    protected function getDefaultSort() {
        return 'DESC';
    }

    protected function getList() {
        parent::getList();

        $this->data['partner_types'] = $this->session->data['partner_types'];

        $this->model['customer'] = $this->load->model('setup/customer');
        $this->data['customers'] = $this->model['customer']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['product'] = $this->load->model('setup/product');
        $this->data['products'] = $this->model['product']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        $this->data['href_print_report'] = $this->url->link($this->getAlias() .'/printReport', 'token=' . $this->session->data['token'], 'SSL');
        $this->data['date_from'] = stdDate($this->session->data['fiscal_date_from']);
        $this->data['date_to'] = stdDate(($this->session->data['fiscal_date_to'] > date('Y-m-d') ? '' : $this->session->data['fiscal_date_to']));

        $this->data['strValidation'] = "{
            'rules': {
                'date_from': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'date_to': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},

            },
            ignore:[],
        }";

        $this->template = $this->getAlias() . '.tpl';

//        //        $this->document->addScript("view/javascript/jquery/jquery.dataTables.min.js");
//        $this->document->addLink("view/stylesheet/dataTables.css", "stylesheet");
//        $this->document->addScript("view/js/plugins/dataTables/js/jquery.dataTables.js");
//        $this->document->addScript("view/js/plugins/dataTables/js/jquery.dataTables.columnFilter.js");
////        $this->document->addLink("view/js/plugins/dataTables/css/jquery.dataTables.css", "stylesheet");
//
//
        $this->response->setOutput($this->render());
    }




    public function printReport() {
        $lang = $this->load->language($this->getAlias());

        $this->init();
        $filter = array();

        if($this->request->post['date_from'])
            $filter['GTE']['document_date'] = MySqlDate($this->request->post['date_from']);
        if($this->request->post['date_to'])
            $filter['LTE']['document_date'] = MySqlDate($this->request->post['date_to']);

        if($this->request->post['supplier_id'])
            $filter['EQ']['supplier_id'] = $this->request->post['supplier_id'];
        if($this->request->post['product_id'])
            $filter['EQ']['product_id'] = $this->request->post['product_id'];

        $cond = getFilterString($filter);

        $this->model['product'] = $this->load->model('setup/product');
        $this->model['partner_type'] = $this->load->model('common/partner_type');
        $this->model['partner'] = $this->load->model('common/partner');

        $product = $this->model['product']->getArrays('product_id','name', array('company_id' => $this->session->data['company_id']));
        $arrProducts = $this->model['product']->getRow(array('product_id' => $this->request->post['product_id']));
        $partnerType = $this->model['partner_type']->getRow(array('partner_type_id' => $this->request->post['partner_type_id']));
        $arrPartnerType = $this->model['partner_type']->getArrays('partner_type_id','name');
        $partner = $this->model['partner']->getRow(array('partner_id' => $this->request->post['partner_id']));
        $arrPartner = $this->model['partner']->getArrays('partner_id','name');



        $this->model['currency'] = $this->load->model('setup/currency');
        $arrCurrency = $this->model['currency']->getArrays('currency_id','currency_code', array('company_id' => $this->session->data['company_id']));
//d($product,true);

        $arrfilter = array(
            'from_date' => $this->request->post['date_from'],
            'to_date' => $this->request->post['date_to'],
            'product' => $arrProducts['name'],
            'partner_type' => $partnerType['name'],
            'partner' => $partner['name'],
        );
//d($arrfilter,true);
        $this->model['company'] = $this->load->model('setup/company');
        $company=$this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));

        $this->model['company_branch'] = $this->load->model('setup/company_branch');
        $company_branch=$this->model['company_branch']->getRow(array('company_id' => $this->session->data['company_id']));

        $this->model['delivery_challan_report'] = $this->load->model('report/delivery_challan_report');
        $rows = $this->model['delivery_challan_report']->getRows($cond,array('document_date ASC'));
//        d($rows,true);
        $arrRows = array();
        foreach($rows as $row) {
            $row['document_date'] = stdDate($row['document_date']);
            if($this->request->post['group_by'] == 'partner') {
                $group_name = $arrPartner[$row['partner_id']];
            } elseif($this->request->post['group_by'] == 'product') {
                $group_name = $product[$row['product_id']];
            } elseif($this->request->post['group_by'] == 'document_date') {
                $group_name = $row['document_date'];
            } elseif($this->request->post['group_by'] == 'warehouse') {
                $group_name = $row['warehouse'];
            } else {
                $group_name = '';
            }

            $groupBy = $this->request->post['group_by'];
            $arrRows[$group_name][] = array(
                'document_type_id' => $row['document_type_id'],
                'document_id' => $row['document_id'],
                'voucher_date' => $row['document_date'],
                'voucher_no' => $row['document_identity'],
                'currency' => $arrCurrency[$row['document_currency_id']],
                'conversion_rate' => $row['conversion_rate'],
                'document_identity' => $row['document_identity'],
                'warehouse_id' => $row['warehouse_id'],
                'warehouse' => $row['warehouse'],
                'product_category_id' => $row['product_category_id'],
                'product_id' => $row['product_id'],
                'product' => $product[$row['product_id']],
                'partner_id' => $row['partner_id'],
                'partner' => $arrPartner[$row['partner_id']],
                'partner_type_id' => $row['partner_type_id'],
                'partner_type' => $arrPartnerType[$row['partner_type_id']],
                'unit_id' => $row['unit_id'],
                'qty' => $row['qty'],
                'rate' => ($row['qty']==0?0:($row['amount']/$row['qty'])),
                'amount' => $row['amount']
            );

        }
//d($row,true);

        $data = array(
            'company' => $company,
            'company_branch' => $company_branch,
            'filter' => $arrfilter,
            'lang' => $lang,
            'rows' => $arrRows,
            'group' => $groupBy,
            'group_name' => $group_name
        );

//d($data,true);
        try
        {
            $pdf=new mPDF();

            $pdf->SetDisplayMode('fullpage');
            $pdf->mPDF('utf-8','A4','','','15','15','45','18');
            $pdf->setHTMLHeader($this->getPDFHeader($data));
            $pdf->setHTMLFooter($this->getPDFFooter($data));
            $pdf->WriteHTML($this->getPDFStyle($data));
            $pdf->WriteHTML($this->getPDFBodySummary($data));

            $pdf->Output();
        }
        catch(Exception $e) {
            echo $e;
            exit;
        }
        exit;
    }

    private function getPDFStyle($data) {
        $html = '';
        $html .= '<style type="text/css">';
        $html .= 'body {';
        $html .= 'background: #FFFFFF;';
        $html .= '}';
        $html .= 'body, td, th, input, select, textarea, option, optgroup {';
        $html .= 'font-family: Arial, Helvetica, sans-serif;';
        $html .= 'font-size: 10px;';
        $html .= 'color: #000000;';
        $html .= '}';
        $html .= 'h1 {';
        $html .= 'text-transform: uppercase;';
        $html .= 'text-align: center;';
        $html .= 'font-size: 24px;';
        $html .= 'font-weight: normal;';
        $html .= 'margin: 5px 0;';
        $html .= '}';
        $html .= 'h2 {';
        $html .= 'text-transform: uppercase;';
        $html .= 'text-align: center;';
        $html .= 'font-size: 18px;';
        $html .= 'font-weight: normal;';
        $html .= 'padding: 0;';
        $html .= 'margin: 0;';
        $html .= '}';
        $html .= 'h3 {';
        $html .= 'text-align: center;';
        $html .= 'font-size: 16px;';
        $html .= 'font-weight: normal;';
        $html .= 'padding: 0;';
        $html .= 'margin: 5px 0 0 0;';
        $html .= '}';
        $html .= 'table.page_header {width: 100%; border: none; background-color: #DDDDFF; border-bottom: solid 1mm #AAAADD; padding: 2mm }';
        $html .= 'table.page_body {width: 100%; border: solid 1px #DDDDDD; border-collapse: collapse; align="center" }';
        $html .= 'table.page_body th {border: solid 1px #000000; border-collapse: collapse; background-color: #CDCDCD; text-align: center; font-size: 12px; padding: 5px;}';
        $html .= 'table.page_body td {border: solid 1px #000000; border-collapse: collapse;font-size: 10px; padding: 5px;}';
        $html .= 'table.page_footer {width: 100%; border: none; background-color: #DDDDFF; border-top: solid 1mm #AAAADD; padding: 2mm}';
        $html .= '</style>';

        return $html;
    }

    private function getPDFHeader($data) {
        $filter = $data['filter'];
        $lang = $data['lang'];
        $company = $data['company'];
        $companyBranch = $data['company_branch'];
        $this->model['image'] = $this->load->model('tool/image');
        $company_image = $this->model['image']->resize($company['company_logo'],50,50);

        $html  = '';
        $html .= '<table class="page_header">';
        $html .= '<tr>';
        $html .= '<td style="width: 33%; text-align: left;">';
        if($company['company_logo']) {
            $html .= '<img src="' . $company_image . '" alt="Logo"/>';
        }
        $html .= '</td>';
        $html .= '<td style="width: 34%; text-align: center">';
        $html .= '<h1>' . $company['name'] .'</h1>';
        $html .= '<h2>' . $companyBranch['name'] . '</h2>';
        $html .= '<h3>' . $lang['heading_title'] . '</h3>';
        $html .= '</td>';
        $html .= '<td style="width: 33%;">';
        $html .= '<table>';
        $html .= '<tr>';
        $html .= '<td style="text-align: right; font-weight: bold">' . $lang['entry_from_date'] . '</td><td style="text-align: left;">' . $filter['from_date'] . '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td style="text-align: right; font-weight: bold">' . $lang['entry_to_date'] . '</td><td style="text-align: left;">' . $filter['to_date'] . '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td style="text-align: right; font-weight: bold">' . $lang['entry_partner_type'] . '</td><td style="text-align: left;">' . $filter['partner_type'] . '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td style="text-align: right; font-weight: bold">' . $lang['entry_partner_name'] . '</td><td style="text-align: left;">' . $filter['partner'] . '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td style="text-align: right; font-weight: bold">' . $lang['entry_product'] . '</td><td style="text-align: left;">' . $filter['product'] . '</td>';
        $html .= '</tr>';
        $html .= '</table>';
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '</table>';

        return $html;
    }

    private function getPDFFooter($data) {
        $html = '';
        $html .= '<table class="page_footer">';
        $html .= '<tr>';
        $html .= '<td style="width: 33%; text-align: left;">';
        $html .= '&nbsp;';
        $html .= '</td>';
        $html .= '<td style="width: 34%; text-align: center">';
        $html .= 'Page: {PAGENO}';
        $html .= '</td>';
        $html .= '<td style="width: 33%; text-align: right">';
        $html .= 'Date: {DATE '.STD_DATETIME.'}';
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '</table>';

        return $html;
    }

    private function getPDFBodySummary($data) {
        $stocks = $data['rows'];
        $lang = $data['lang'];
        $group = $data['group'];
        $group_name = $data['group_name'];
//d($group_name,true);
        $html = '';
        foreach($stocks as $group_name => $products) {
            $total_qty = 0;
            $total_amount =0;
            $base_amount = 0;
            $total_base_amount = 0;

            $html .= '<div style="padding-top: 10px;">';
            if($group == 'partner')
            {
                $html .= '<div style="font-size: 12px;"><strong>' . $lang['entry_partner_name'] . '</strong>' .$group_name . '</div>';
            }
            elseif($group == 'product')
            {
                $html .= '<div style="font-size: 12px;"><strong>' . $lang['entry_product'] . '</strong>' . $group_name . '</div>';
            }
            elseif($group == 'document_date')
            {
                $html .= '<div style="font-size: 12px;"><strong>' . $lang['entry_date'] . '</strong>' . $group_name . '</div>';
            }
            elseif($group == 'warehouse')
            {
                $html .= '<div style="font-size: 12px;"><strong>' . $lang['entry_warehouse'] . '</strong>' . $group_name . '</div>';
            }
            $html .= '<table class="page_body">';
            $html .= '<thead>';
            $html .= '<tr>';
            $html .= '<th style="width: 10%;">' . $lang['column_document_date'] . '</th>';
            $html .= '<th style="width: 10%;">' . $lang['column_voucher_no'] . '</th>';
            $html .= '<th style="width: 18%;">' . $lang['partner_name'] . '</th>';
            $html .= '<th style="width: 18%;">' . $lang['column_product'] . '</th>';
            $html .= '<th style="width: 8%;">' . $lang['column_qty'] . '</th>';
//            $html .= '<th style="width: 10%;">' . $lang['column_rate'] . '</th>';
//            $html .= '<th style="width: 14%;">' . $lang['column_amount'] . '</th>';
//            $html .= '<th style="width: 15%;">' . $lang['column_currency'] . '</th>';
//            $html .= '<th style="width: 8%;">' . $lang['column_conversion'] . '</th>';
//            $html .= '<th style="width: 14%;">' . $lang['column_base_amount'] . '</th>';

            $html .= '</tr>';
            $html .= '</thead>';
            $html .= '<tbody>';
            foreach($products as $product => $row) {
                $total_qty += $row['qty'];
                $total_amount += $row['amount'];
                $base_amount = $row['amount'] * $row ['conversion_rate'] ;
                $total_base_amount += $base_amount;

                $html .= '<tr>';
                $html .= '<td style="text-align:left;">' . $row['voucher_date'] . '</td>';
                $html .= '<td style="text-align:left;">' . $row['voucher_no'] . '</td>';
                $html .= '<td style="text-align:left;">' . $row['partner'] . '</td>';
                $html .= '<td style="text-align:left;">' . $row['product'] . '</td>';
                $html .= '<td style="text-align:right;">' . number_format($row['qty'],0) . '</td>';

//                $html .= '<td style="text-align:left;">' . $row['currency'] . '</td>';
//                $html .= '<td style="text-align:right;">' . number_format($row['conversion_rate'],2) . '</td>';
//                $html .= '<td style="text-align:right;">' . number_format($base_amount,2) . '</td>';
                $html .= '</tr>';
            }
            $html .= '</tbody>';
            $html .= '<tfoot>';
            $html .= '<tr>';
            $html .= '<th colspan="4">&nbsp;</th>';
            $html .= '<th style="text-align:right;">' . number_format($total_qty,0) . '</th>';

//            $html .= '<th style="text-align:right;">&nbsp;</th>';
//            $html .= '<th style="text-align:right;">&nbsp;</th>';
//            $html .= '<th style="text-align:right;">' . number_format($total_base_amount,2) . '</th>';
            $html .= '</tr>';
            $html .= '</tfoot>';
            $html .= '</table>';
            $html .= '</div>';
            $html .= '<pagebreak />';
        }
        $html = substr($html,0,strlen($html)-13);
        return $html;
    }
}
?>