<?php

class ControllerGlAdvancePayment extends HController {

    protected $document_type_id = 14;

    protected function getAlias() {
        return 'gl/advance_payment';
    }

    protected function getPrimaryKey() {
        return 'advance_payment_id';
    }

    protected function getList() {
        parent::getList();

        $this->data['action_ajax'] = $this->url->link($this->getAlias() . '/getAjaxLists', 'token=' . $this->session->data['token'], 'SSL');

        $this->response->setOutput($this->render());
    }

    public function getAjaxLists() {

        $lang = $this->load->language('gl/advance_payment');
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());

        $data = array();
        $aColumns = array('action','document_date', 'document_identity' ,'partner_type','partner_name', 'remarks','amount','created_at', 'check_box');

        /*
         * Paging
         */
        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $data['criteria']['start'] = $_GET['iDisplayStart'];
            $data['criteria']['limit'] = $_GET['iDisplayLength'];
        }

        /*
         * Ordering
         */
        $sOrder = "";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = " ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= "`" . $aColumns[intval($_GET['iSortCol_' . $i])] . "` " .
                        ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == " ORDER BY") {
                $sOrder = "";
            }
            $data['criteria']['orderby'] = $sOrder;
        }


        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $arrWhere = array();
        $arrWhere[] = "`company_id` = '".$this->session->data['company_id']."'";
        $arrWhere[] = "`company_branch_id` = '".$this->session->data['company_branch_id']."'";
        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {
            $arrSSearch = array();
            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch'] != '') {
                    $arrSSearch[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch'])) . "%'";
                }
            }
            if(!empty($arrSSearch)) {
                $arrWhere[] = '(' . implode(' OR ', $arrSSearch) . ')';
            }
        }

        /* Individual column filtering */
        for ($i = 0; $i < count($aColumns); $i++) {
            if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true" && $_GET['sSearch_' . $i] != '') {
                $arrWhere[] = "LOWER(`" . $aColumns[$i] . "`) LIKE '%" . $this->db->escape(strtolower($_GET['sSearch_' . $i])) . "%' ";
            }
        }

        if (!empty($arrWhere)) {
            //$data['filter']['RAW'] = substr($sWhere, 5, strlen($sWhere) - 5);
            $data['filter']['RAW'] = implode(' AND ', $arrWhere);
        }

        //d($data, true);
        $results = $this->model[$this->getAlias()]->getLists($data);
        $iFilteredTotal = $results['total'];
        $iTotal = $results['table_total'];


        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($results['lists'] as $aRow) {
            $row = array();
            $actions = array();

            $actions[] = array(
                'text' => $lang['edit'],
                'href' => $this->url->link($this->getAlias() . '/update', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-primary btn-xs',
                'class' => 'fa fa-pencil'
            );


            $actions[] = array(
                'text' => $lang['print'],
                'target' => '_blank',
                'href' => $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                'btn_class' => 'btn btn-info btn-xs',
                'class' => 'fa fa-print'
            );

            if($aRow['is_post']==0) {
                $actions[] = array(
                    'text' => $lang['post'],
                    'href' => $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $aRow[$this->getPrimaryKey()], 'SSL'),
                    'btn_class' => 'btn btn-info btn-xs',
                    'class' => 'fa fa-thumbs-up'
                );

                $actions[] = array(
                    'text' => $lang['delete'],
                    'href' => 'javascript:void(0);',
                    'click' => "ConfirmDelete('" . $this->url->link($this->getAlias() . '/delete', 'token=' . $this->session->data['token'] . '&id=' . $aRow[$this->getPrimaryKey()], 'SSL') . "')",
                    'btn_class' => 'btn btn-danger btn-xs',
                    'class' => 'fa fa-times'
                );
            }

            $strAction = '';
            foreach ($actions as $action) {
                $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' '.(isset($action['target'])?'target="'.$action['target'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
//              $strAction .= '<a '.(isset($action['btn_class'])?'class="'.$action['btn_class'].'"':'').' href="' . $action['href'] . '" data-toggle="tooltip" title="' . $action['text'] . '" ' . (isset($action['click']) ? 'onClick="' . $action['click'] . '"' : '') . '>';
                if (isset($action['class'])) {
                    $strAction .= '<span class="' . $action['class'] . '"></span>';
                } else {
                    $strAction .= $action['text'];
                }
                $strAction .= '</a>&nbsp;';
            }

            for ($i = 0; $i < count($aColumns); $i++) {
                if ($aColumns[$i] == 'action') {
                    $row[] = $strAction;
                } elseif ($aColumns[$i] == 'created_at') {
                    $row[] = stdDateTime($aRow['created_at']);
                }  elseif ($aColumns[$i] == 'document_date') {
                    $row[] = stdDate($aRow['document_date']);
                } elseif ($aColumns[$i] == 'check_box') {
                    if($aRow['is_post']==0) {
                        $row[] = '<input type="checkbox" name="selected[]" value="' . $aRow[$this->getPrimaryKey()] . '" />';
                    } else {
                        $row[] = '';
                    }
                }else {
                    $row[] = $aRow[$aColumns[$i]];
                }
            }
            $output['aaData'][] = $row;
        }

        echo json_encode($output);
    }

    protected function getForm() {
        parent::getForm();

        $this->data['document_identity'] = $this->data['lang']['auto'];
        $this->data['document_date'] = stdDate();
        $this->data['base_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['base_currency'] = $this->session->data['base_currency_name'];
        $this->data['document_currency_id'] = $this->session->data['base_currency_id'];
        $this->data['conversion_rate'] = "1.00";

        $this->model['currency'] = $this->load->model('setup/currency');
        $this->data['currencies'] = $this->model['currency']->getRows(array('company_id' => $this->session->data['company_id']));

        $this->model['coa'] = $this->load->model('gl/coa');
        $this->model['setting']= $this->load->model('common/setting');
        $bank_accounts = $this->model['setting']->getRows(array(
            'company_id' => $this->session->data['company_id'],
//            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'gl',
            'field' => 'cash_account_id',
        ));
        foreach($bank_accounts as $bank_account) {
            $this->data['transaction_accounts'][] = $this->model['coa']->getRow(array('company_id' => $this->session->data['company_id'], 'coa_id' => $bank_account['value']));
        }
        //d($bank_accounts,true);
        $bank_accounts = $this->model['setting']->getRows(array(
            'company_id' => $this->session->data['company_id'],
//            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'gl',
            'field' => 'bank_account_id',
        ));
        foreach($bank_accounts as $bank_account) {
            $this->data['transaction_accounts'][] = $this->model['coa']->getRow(array('company_id' => $this->session->data['company_id'], 'coa_id' => $bank_account['value']));
        }
        // d($bank_accounts,true);

        $this->model['setting']= $this->load->model('common/setting');
        $withholding_tax_accounts = $this->model['setting']->getRows(array(
            'company_id' => $this->session->data['company_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'module' => 'gl',
            'field' => 'withholding_tax_account_id',
        ));
        foreach($withholding_tax_accounts as $withholding_tax_account) {
            $this->data['withholding_tax_accounts'][] = $this->model['coa']->getRow(array('company_id' => $this->session->data['company_id'], 'coa_id' => $withholding_tax_account['value']));
        }

//        d($this->data['withholding_tax_accounts'],true);


        $this->data['partner_types'] = $this->session->data['partner_types'];

        if (isset($this->request->get['advance_payment_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->data['isEdit'] = 1;
            $this->data['document_type_id'] = $this->document_type_id;
            $this->data['document_id'] = $this->request->get['advance_payment_id'];
            $result = $this->model[$this->getAlias()]->getRow(array('advance_payment_id' => $this->request->get['advance_payment_id']));
            //d($result, true);
            foreach($result as $field => $value) {
                if($field == 'document_date') {
                    $this->data[$field] = stdDate($value);
                } elseif($field == 'cheque_date') {
                    if($value == '') {
                        $this->data[$field] = '';
                    } else {
                        $this->data[$field] = stdDate($value);
                    }
                } else
                    $this->data[$field] = $value;
            }

            $this->model['ledger'] = $this->load->model('gl/ledger');
            $this->data['ledgers'] = $this->model['ledger']->getRows(array('document_type_id' => $this->document_type_id, 'document_id' => $this->request->get[$this->getPrimaryKey()]),array('sort_order ASC'));

            $this->model['partner'] = $this->load->model('common/partner');
            $this->data['partners'] = $this->model['partner']->getRows(array('partner_type_id' => $result['partner_type_id']));
        }


        $this->data['href_get_document_ledger'] = $this->url->link('common/function/getDocumentLedger', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['href_get_bank'] = $this->url->link('gl/advance_payment/getAccounts', 'token=' . $this->session->data['token']);
        $this->data['href_get_partner'] = $this->url->link('common/function/getPartner', 'token=' . $this->session->data['token']);
        $this->data['action_post'] = $this->url->link($this->getAlias() . '/post', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_un_post'] = $this->url->link($this->getAlias() . '/Unpost', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_print'] = $this->url->link($this->getAlias() . '/printDocument', 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL');
        $this->data['action_validate_date'] = $this->url->link('common/function/validateDate', 'token=' . $this->session->data['token']);
        $this->data['strValidation'] = "{
            'rules': {
                'document_date': {'required': true, 'remote':  {url: '" . $this->data['action_validate_date'] . "', type: 'post'}},
                'transaction_account_id': {'required': true},
                'amount': {'required': true},
            },
            ignore:[],
        }";

        $this->response->setOutput($this->render());
    }

    public function Unpost() {

        $lang = $this->load->language($this->getAlias());
        $data = array(
            'is_post' => 0,
            'post_date' => date('Y-m-d H:i:s'),
            'post_by_id' => $this->session->data['user_id']
        );
        $this->model[$this->getAlias()] = $this->load->model($this->getAlias());
        $this->model[$this->getAlias()]->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);

        $this->model['document'] = $this->load->model('common/document');
        $this->model['document']->edit($this->getAlias(),$this->request->get[$this->getPrimaryKey()],$data);

        $this->redirect($this->url->link($this->getAlias(), 'token=' . $this->session->data['token'] . '&' . $this->getPrimaryKey() . '=' . $this->request->get[$this->getPrimaryKey()], 'SSL'));
    }


    protected function insertData($data) {
        $this->model['document_type'] = $this->load->model('common/document_type');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $document = $this->model['document_type']->getNextDocument($this->document_type_id);

        $data['document_date'] = MySqlDate($data['document_date']);

        if($data['cheque_date'] != '') {
            $data['cheque_date'] = MySqlDate($data['cheque_date']);
        } else {
            $data['cheque_date'] = NULL;
        }

        //$data['cheque_date'] = MySqlDate($data['cheque_date']);
        $data['company_id'] = $this->session->data['company_id'];
        $data['company_branch_id'] = $this->session->data['company_branch_id'];
        $data['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
        $data['document_type_id'] = $this->document_type_id;
        $data['document_prefix'] = $document['document_prefix'];
        $data['document_no'] = $document['document_no'];
        $data['document_identity'] = $document['document_identity'];
        $data['base_amount'] = $data['amount'] * $data['conversion_rate'];
        $data['base_wht_tax_amount'] = $data['wht_tax_amount'] * $data['conversion_rate'];

        $advance_payment_id = $this->model[$this->getAlias()]->add($this->getAlias(), $data);
        $data['document_id'] = $advance_payment_id;

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);

        $this->model['partner'] = $this->load->model('common/partner');
        $partner = $this->model['partner']->getRow(array('partner_type_id' => $data['partner_type_id'], 'partner_id' => $data['partner_id']));

        $gl_data = array();

        $gl_data[] = array(
            'coa_id' => $partner['advance_account_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_debit' => $data['amount'],
            'document_credit' => 0,
            'base_currency_id' => $data['base_currency_id'],
            'conversion_rate' => $data['conversion_rate'],
            'debit' => $data['amount'] * $data['conversion_rate'],
            'credit' => 0,
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'ref_document_type_id' => $this->document_type_id,
            'ref_document_identity' => $data['document_identity'],
            'cheque_date' => $data['cheque_date'],
            'cheque_no' => $data['cheque_no'],
        );

        if(floatval($data['wht_tax_amount'] > 0))
        {
            $gl_data[] = array(
                'coa_id' => $data['wht_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => $data['wht_tax_amount'],
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => $data['wht_tax_amount'] * $data['conversion_rate'],
                'cheque_date' => $data['cheque_date'],
                'cheque_no' => $data['cheque_no'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

            $gl_data[] = array(
                'coa_id' => $data['transaction_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => ($data['amount'] - $data['wht_tax_amount']),
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => ($data['amount'] - $data['wht_tax_amount']) * $data['conversion_rate'],
                'cheque_date' => $data['cheque_date'],
                'cheque_no' => $data['cheque_no'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

        }
        else{

            $gl_data[] = array(
                'coa_id' => $data['transaction_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => ($data['amount']),
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => ($data['amount']) * $data['conversion_rate'],
                'cheque_date' => $data['cheque_date'],
                'cheque_no' => $data['cheque_no'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

        }

        $this->model['gl'] = $this->load->model('gl/ledger');
        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $advance_payment_id;
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['remarks'] = $data['remarks'];
            $ledger['sort_order'] = $sort_order;

            $this->model['gl']->add($this->getAlias(),$ledger);
        }
        return $advance_payment_id;
    }

    protected function insertRedirect($id, $data) {
        $url = $this->getURL();
        $this->redirect($this->url->link($this->getAlias().'/update', 'token=' . $this->session->data['token'] . $url . '&print=1&advance_payment_id=' . $id, 'SSL'));
    }

    protected function updateData($primary_key, $data) {

        $this->model['document_type'] = $this->load->model('common/document_type');
        $this->model['document'] = $this->load->model('common/document');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $this->model['document']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));

        $data['document_date'] = MySqlDate($data['document_date']);
        if($data['cheque_date'] != '') {
            $data['cheque_date'] = MySqlDate($data['cheque_date']);
        } else {
            $data['cheque_date'] = NULL;
        }
        $data['base_amount'] = $data['amount'] * $data['conversion_rate'];
        $data['base_wht_tax_amount'] = $data['wht_tax_amount'] * $data['conversion_rate'];

        $advance_payment_id = $this->model[$this->getAlias()]->edit($this->getAlias(), $primary_key, $data);
        $data['document_id'] = $advance_payment_id;

        $insert_document = array(
            'company_id' => $this->session->data['company_id'],
            'company_branch_id' => $this->session->data['company_branch_id'],
            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
            'document_type_id' => $this->document_type_id,
            'document_id' => $data['document_id'],
            'document_identity' => $data['document_identity'],
            'document_date' => $data['document_date'],
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_amount' => $data['amount'],
            'conversion_rate' => $data['conversion_rate'],
            'base_currency_id' => $data['base_currency_id'],
            'base_amount' => $data['base_amount'],
        );
        $document_id = $this->model['document']->add($this->getAlias(), $insert_document);

        $this->model['partner'] = $this->load->model('common/partner');
        $partner = $this->model['partner']->getRow(array('partner_type_id' => $data['partner_type_id'], 'partner_id' => $data['partner_id']));

        $gl_data = array();
        $gl_data[] = array(
            'coa_id' => $partner['advance_account_id'],
            'document_currency_id' => $data['document_currency_id'],
            'document_debit' => $data['amount'],
            'document_credit' => 0,
            'base_currency_id' => $data['base_currency_id'],
            'conversion_rate' => $data['conversion_rate'],
            'debit' => $data['amount'] * $data['conversion_rate'],
            'credit' => 0,
            'partner_type_id' => $data['partner_type_id'],
            'partner_id' => $data['partner_id'],
            'ref_document_type_id' => $this->document_type_id,
            'ref_document_identity' => $data['document_identity'],
        );

        if(floatval($data['wht_tax_amount'] > 0))
        {
            $gl_data[] = array(
                'coa_id' => $data['wht_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => $data['wht_tax_amount'],
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => $data['wht_tax_amount'] * $data['conversion_rate'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

            $gl_data[] = array(
                'coa_id' => $data['transaction_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => ($data['amount'] - $data['wht_tax_amount']),
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => ($data['amount'] - $data['wht_tax_amount']) * $data['conversion_rate'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

        }
        else{

            $gl_data[] = array(
                'coa_id' => $data['transaction_account_id'],
                'document_currency_id' => $data['document_currency_id'],
                'document_debit' => 0,
                'document_credit' => ($data['amount']),
                'base_currency_id' => $data['base_currency_id'],
                'conversion_rate' => $data['conversion_rate'],
                'debit' => 0,
                'credit' => ($data['amount']) * $data['conversion_rate'],
                //'partner_type_id' => $data['partner_type_id'],
                //'partner_id' => $data['partner_id'],
                //'ref_document_type_id' => $data['document_type_id'],
                //'ref_document_identity' => $data['document_identity'],
            );

        }



        $this->model['gl'] = $this->load->model('gl/ledger');
        foreach($gl_data as $sort_order => $ledger) {
            $ledger['company_id'] = $this->session->data['company_id'];
            $ledger['company_branch_id'] = $this->session->data['company_branch_id'];
            $ledger['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
            $ledger['document_type_id'] = $this->document_type_id;
            $ledger['document_id'] = $advance_payment_id;
            $ledger['document_identity'] = $data['document_identity'];
            $ledger['document_date'] = $data['document_date'];
            $ledger['base_currency_id'] = $data['base_currency_id'];
            $ledger['document_currency_id'] = $data['document_currency_id'];
            $ledger['remarks'] = $data['remarks'];
            $ledger['sort_order'] = $sort_order;

            $this->model['gl']->add($this->getAlias(),$ledger);
        }

        return $advance_payment_id;
    }

    protected function deleteData($primary_key) {
        $this->model['document'] = $this->load->model('common/document');
        $this->model['ledger'] = $this->load->model('gl/ledger');

        $this->model['ledger']->deleteBulk($this->getAlias(), array('document_id' => $primary_key));
        $this->model['document']->delete($this->getAlias(), $primary_key);
        $this->model[$this->getAlias()]->delete($this->getAlias(), $primary_key);

    }

//    public function getpartner() {
//        $partner_id = $this->request->get['partner_id'];
//        $partner_type_id = $this->request->post['partner_type_id'];
//
//        $filter = array(
//            'company_id' => $this->session->data['company_id'],
//            'partner_type_id' => $partner_type_id,
//        );
//        $this->model['partner'] = $this->load->model('common/partner');
//        $partners = $this->model['partner']->getRows($filter);
//        $html = '<option value="">&nbsp;</option>';
//        foreach($partners as $partner) {
//            $html .= '<option value="' . $partner['partner_id'] . '" '.($partner_id == $partner['partner_id']?'selected="true"':'').'>'.$partner['partner_name'].'</option>';
//        }
//
//        echo json_encode(array('success' => true, 'html' => $html));
//    }
//
//    public function getAccounts() {
//        $bank_account = $this->request->post['bank_account'];
//
//        $this->model['mapping_coa'] = $this->load->model('gl/mapping_coa');
//        $transaction_accounts = $this->model['mapping_coa']->getRows(array('mapping_type_code' => $bank_account),array('level3_display_name'));
//
//        $html = '<option value="">&nbsp;</option>';
//        foreach($transaction_accounts as $transaction_account) {
//            $html .= '<option value="' . $transaction_account['coa_level3_id'] . '" '.($transaction_account['coa_level3_id']?'selected="true"':'').'>'.$transaction_account['level3_display_name'].'</option>';
//        }
//
//        echo json_encode(array('success' => true, 'html' => $html));
//    }
//
//
//    public function getReferenceDocumentTypes() {
//        $filter = $this->request->post;
//        $filter['company_id'] = $this->session->data['company_id'];
//        $filter['company_branch_id'] = $this->session->data['company_branch_id'];
//        $filter['fiscal_year_id'] = $this->session->data['fiscal_year_id'];
//
//
//        $this->model['document'] = $this->load->model('common/document');
//        $document_types = $this->model['document']->getDocumentTypes($filter);
//        $html = '<option value="">&nbsp;</option>';
//        foreach($document_types as $document_type) {
//            $html .= '<option value="'.$document_type['document_type_id'].'">'.$document_type['document_type'].'</option>';
//        }
//
//        echo json_encode(array('success' => true, 'filter' => $filter, 'document_types' => $document_types, 'html' => $html));
//    }
//
//    public function getReferenceDocumentNos() {
//        $excl_document_id = $this->request->get['advance_payment_id'];
//        $post = $this->request->post;
//        $html = "";
//        $html .= '<option value="">&nbsp;</option>';
//
//        $documents = $this->getReferenceDocs($post,$excl_document_id);
//        $this->model['purchase_order'] = $this->load->model('transaction/purchase_order');
//
////        d($documents,true);
//        foreach($documents as $document_id => $document) {
//            $purchase_order = $this->model['purchase_order']->getRow(array('purchase_order_id' => $document['document_id']));
//
//            $html .= '<option value="'.$document_id.'">'.$document['document_identity'].' '.'('.$purchase_order['manual_ref_no'].')'. '</option>';
//        }
////        d($document,true);
//
//        echo json_encode(array('success' => true, 'post' => $post, 'html' => $html));
//    }
//
//    private function getReferenceDocs($post, $excl_document_id = '') {
//        $document_type_id = $post['document_type_id'];
//        if($document_type_id == 4) {
//            //Purchase Order
//            $this->model['purchase_order'] = $this->load->model('transaction/purchase_order');
//            $where = "company_id=" . $this->session->data['company_id'];
//            $where .= " AND company_branch_id='" . $this->session->data['company_branch_id'] . "'";
//            $where .= " AND fiscal_year_id=" . $this->session->data['fiscal_year_id'];
//            $where .= " AND supplier_id='" . $post['partner_id'] . "'";
//            $where .= " AND document_currency_id='" . $post['document_currency_id'] . "'";
////            $where .= " AND is_post=1";
//
//            $purchase_orders = $this->model['purchase_order']->getPurchaseOrders($where,$excl_document_id);
//            foreach($purchase_orders as $purchase_order_id => $purchase_order) {
//                foreach($purchase_order['products'] as $product_id => $product) {
//                    if($product['order_qty'] <= $product['utilized_qty']) {
//                        unset($purchase_order['products'][$product_id]);
//                    }
//                }
//                if(empty($purchase_order['products'])) {
//                    unset($purchase_orders[$purchase_order_id]);
//                }
//            }
//        }
//
//        return $purchase_orders;
//    }
//
//    public function getpartnerOptions() {
//        $filter = array(
//            'company_id' => $this->session->data['company_id'],
//            'fiscal_year_id' => $this->session->data['fiscal_year_id'],
//            'partner_type_id' => $this->request->post['partner_type_id'],
//            'partner_id' => $this->request->post['partner_id']
//        );
//        echo json_encode($this->partnerOptions($filter));
//    }
//
//    private function partnerOptions($filter= array()) {
//        $optionDocumentIdentity = '';
//        $optionCOA = '';
//        $arrOptionDocumentIdentity = '';
//        $arrOptionCOA = '';
//        if($filter['partner_id'] && $filter['partner_id'] != "") {
//            $arrFilter['EQ'] = array(
//                'l.company_id' => $this->session->data['company_id'],
//                'l.fiscal_year_id' => $this->session->data['fiscal_year_id'],
//                'l.partner_type_id' => $filter['partner_type_id'],
//                'l.partner_id' => $filter['partner_id']
//            );
//            if($filter['document_id'])
//                $arrFilter['NEQ'] = array('l.document_id' => $filter['document_id']);
//
//            $filterString = getFilterString($arrFilter);
//
//            $this->model['ledger'] = $this->load->model('gl/ledger');
//            $out_standings = $this->model['ledger']->getOutStanding($filterString);
//
//            $this->model['document'] = $this->load->model('common/document');
//            foreach($out_standings as $out_standing) {
//                $filterDocument = array(
//                    'company_id' => $this->session->data['company_id'],
//                    'fiscal_year_id' => $this->session->data['fiscal_year_id'],
//                    'document_type_id' => $out_standing['ref_document_type_id'],
//                    'document_identity' => $out_standing['ref_document_identity']
//                );
//                $document_invoice = $this->model['document']->getRow($filterDocument);
//                $optionDocumentIdentity .= '<option value="' . $out_standing['ref_document_identity'] . '" document_outstanding="' . $out_standing['outstanding'] . '" >'.$out_standing['ref_document_identity'] . ' (' . $document_invoice["document_amount"] .')</option>';
//                $arrOptionDocumentIdentity[] = array(
//                    'value' => $out_standing['ref_document_identity'],
//                    'document_outstanding' => $out_standing['outstanding'],
//                    'option' => $out_standing['ref_document_identity'] . ' (' . $document_invoice["document_amount"] .')'
//                );
//            }
//
//            $this->model['partner'] = $this->load->model('common/partner');
//            $partner = $this->model['partner']->getRow($filter);
//
//            $optionCOA .= '<option value="' . $partner['outstanding_account_id'] . '">'.$partner['outstanding_account'].'</option>';
//            $arrOptionCOA[] = array(
//                'value' => $partner['outstanding_account_id'],
//                'option' => $partner['outstanding_account']
//            );
//            $arrOptions = array(
//                'success' => true,
//                'optionDocumentIdentity' => $optionDocumentIdentity,
//                'optionCOA' => $optionCOA,
//                'arrOptionDocumentIdentity' => $arrOptionDocumentIdentity,
//                'arrOptionCOA' => $arrOptionCOA,
//            );
//        } else {
//            $this->model['gl'] = $this->load->model('gl/coa');
//            $coas = $this->model['gl']->getRows(array('company_id' => $this->session->data['company_id']));
//
//            foreach($coas as $coa) {
//                $optionCOA .= '<option value="' . $coa['coa_id'] . '">'.$coa['display_name'].'</option>';
//                $arrOptionCOA[] = array(
//                    'value' => $coa['coa_id'],
//                    'option' => $coa['display_name']
//                );
//            }
//
//            $arrOptions = array(
//                'success' => true,
//                'optionDocumentIdentity' => '',
//                'optionCOA' => $optionCOA,
//                'arrOptionDocumentIdentity' => $arrOptionDocumentIdentity,
//                'arrOptionCOA' => $arrOptionCOA,
//            );
//        }
//        return $arrOptions;
//    }

    public function printDocument() {

        ini_set('max_execution_time',0);
        ini_set('memory_limit',-1);

        $lang = $this->load->language($this->getAlias());
        $BankReceiptId = $this->request->get['advance_payment_id'];
        $post = $this->request->post;
        $session = $this->session->data;

        $this->model['company'] = $this->load->model('setup/company');
        $this->model['company_branch'] = $this->load->model('setup/company_branch');
        $this->model['advance_payment'] = $this->load->model('gl/advance_payment');

        $this->model['coa'] = $this->load->model('gl/coa');


        $company = $this->model['company']->getRow(array('company_id' => $this->session->data['company_id']));
        $company_branch = $this->model['company_branch']->getRow(array('company_branch_id' => $session['company_branch_id']));
        $BankReceipt = $this->model['advance_payment']->getRow(array('advance_payment_id' => $BankReceiptId));
        $TransactionAccount = $this->model['coa']->getRow(array('coa_id' => $BankReceipt['transaction_account_id']));


//        d($BankReceiptDetails,true);


        $this->model['ledger'] = $this->load->model('gl/ledger');
        $LedgerDetails = $this->model['ledger']->getTransactionLedger(14,$BankReceiptId);



        $pdf = new PDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Abdul Samad Khan');
        $pdf->SetTitle('Advance Payment');
        $pdf->SetSubject('Advance Payment');

        //Set Header
        $pdf->data = array(
            'company_name' => $session['company_name'],
            'address' => $company_branch['address'],
            'ntn' => $company_branch['ntn'],
            'strn' => $company_branch['strn'],
            'email_address' => $company_branch['email_address'],
            'company_phone' => $company_branch['phone_no'],
            'report_name' => 'Advance Payment',
            'company_logo' => $session['company_image'],
            'document_identity' => $BankReceipt['document_identity'],
            'dc_no' => $BankReceipt['dc_no'],
            'document_date' => $BankReceipt['document_date'],
            'partner_name' => $BankReceipt['partner_name'],
            'remarks' => $BankReceipt['remarks']

        );

        $pdf->SetMargins(15, 30, 5);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 40);

        // add a page
        $pdf->AddPage();
        // set font
        $pdf->SetFont('times', 'B', 12);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Cell(190, 7, 'ADVANCE PAYMENT VOUCHER', 'T,B', false, 'C', 1, '', 1);
        $pdf->ln(10);

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(18, 6, 'Voucher No: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', '', 8);
        $pdf->Cell(40, 6, $BankReceipt['document_identity'], 0, false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', 'B', 8);
        $pdf->Cell(80, 6, 'Voucher Date: ', 0, false, 'R', 0, '', 0, false, 'M', 'M');

        $pdf->SetFont('times', '', 8);
        $pdf->Cell(20, 6, stdDate($BankReceipt['document_date']), 0, false, 'L', 0, '', 0, false, 'M', 'M');

        $pdf->ln(6);

        $pdf->SetFont('times', 'B', 8);

        $pdf->Cell(18, 6, 'Remarks : ', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $pdf->SetFont('times','', 8);
        $pdf->SetFillColor(255,255,255);
        $pdf->MultiCell(160, 8, html_entity_decode($BankReceipt['remarks']), 0, 'L', 1, 0, '', '', true, 0, false, true, 40, 'T');

        $pdf->ln(9);
        $pdf->SetFont('times', 'B', 8);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Cell(25, 7, 'Code.', 'T,B', false, 'C', 1, '', 1);
        $pdf->Cell(105, 7, 'Accounts Description', 'T,B', false, 'L', 1, '', 1);
        $pdf->Cell(30, 7, 'Debit', 'T,B', false, 'C', 1, '', 1);
        $pdf->Cell(30, 7, 'Credit', 'T,B', false, 'C', 1, '', 1);

        $pdf->SetFont('times', '', 8);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetTextColor(0, 0, 0);
        $total_debit = 0;
        $total_credit = 0;
//        foreach($BankReceiptDetails as $detail) {
//
//
//            $Account = $this->model['coa']->getRow(array('coa_id' => $detail['coa_id']));
//
//            $Amount += $detail['amount'];
//            $WhAmount += $detail['wht_amount'];
//            $OtAmount += $detail['other_tax_amount'] ;
//            $NetAmount += $detail['net_amount'] ;
//           /* d($Account,true);*/
//            $sr++;
//            $pdf->Ln(7);
//            $pdf->Cell(55, 7, $Account['level4_name'], 1, false, 'L', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(25, 7, $detail['remarks'], 1, false, 'L', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(20, 7, stdDate($detail['cheque_date']), 1, false, 'L', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(20, 7, $detail['cheque_no'], 1, false, 'L', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(21, 7, number_format($detail['amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(21, 7, number_format($detail['wht_amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(21, 7, number_format($detail['other_tax_amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
//            $pdf->Cell(21, 7, number_format($detail['net_amount'],2), 1, false, 'R', 0, '', 0, false, 'M', 'M');
//        }

        foreach($LedgerDetails as $LedgerDetail) {
            $pdf->ln(12);

            $pdf->Cell(25, 6, $LedgerDetail['account_code'], 0, false, 'L', 0, '', 1,false, 'T', 'T');
            //$pdf->Cell(80, 5, html_entity_decode($LedgerDetail['level4_name']), 0, false, 'L', 0, '', 1);
            $pdf->MultiCell(105, 8, html_entity_decode($LedgerDetail['level4_name'])."\n".html_entity_decode($LedgerDetail['remarks']), 0, 'L', 1, 0, '', '', true, 0, false, true, 40, 'T');
            $pdf->Cell(30, 6, number_format($LedgerDetail['debit'],4), 0, false, 'R', 0, '', 1,false, 'T', 'T');
            $pdf->Cell(30, 6, number_format($LedgerDetail['credit'],2), 0, false, 'R', 0, '', 1,false, 'T', 'T');

            $total_debit += $LedgerDetail['debit'];
            $total_credit += $LedgerDetail['credit'];
        }
        $pdf->Ln(4);

        $x = $pdf->GetX();
        $y = $pdf->GetY();
        $pdf->setXY($x,$y);
        $pdf->SetFont('times', 'B', 9);

        $pdf->Ln(10);
        $pdf->Cell(1, 7, '', 0, false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(134, 5, 'Totals', 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(25, 5, number_format($total_debit,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(30, 5, number_format($total_credit,2), 'T,B', false, 'R', 0, '', 0, false, 'M', 'M');
        $pdf->Ln(7);
        $pdf->SetFont('times', '', 8);
        $pdf->Cell(30, 6, 'Amount in Word: ', 0, false, 'L', 0, '', 1);
        $pdf->SetFont('times', 'B', 8);

        //$pdf->Cell(160, 6, 'Rupees '.Number2Words(number_format($total_debit,2)).' Only.', 0, false, 'L', 0, '', 1);
        $pdf->Cell(160, 6,'Rupees '.Number2Words(round($total_debit),2).' Only.', 0, false, 'L', 0, '', 1);
        $pdf->Ln(30);
        $pdf->SetFont('times', 'B', 8);
        //$pdf->Cell(180, 4, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
        //$pdf->Ln(10);

        $pdf->Cell(33, 7, 'Prepared By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Checked By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Approved By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(16, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $pdf->Cell(33, 7, 'Received By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');

        //Close and output PDF document
        $pdf->Output('Advance Payment :'.date('YmdHis').'.pdf', 'I');
    }

}

class PDF extends TCPDF {
    public $data = array();

    //Page header
    public function Header() {
        // Logo
//        if($this->data['company_logo'] != '') {
//            $image_file = DIR_IMAGE.$this->data['company_logo'];
//            //$this->Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false);
//            $this->Image($image_file, 10, 10, 30, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//        }
//        // Set font
//        $this->SetTextColor(255,255,255);
//        $this->SetFont('helvetica', 'B', 10);
//        $this->Ln(2);
//        // Title
//        $this->Cell(0, 4, $this->data['company_name'], 0, false, 'C', 1, '', 0, false, 'M', 'M');
//        $this->Ln(4);
//        if($this->data['company_address']) {
//            $this->Cell(0, 4, $this->data['company_address'], 0, false, 'C', 0, '', 1, false, 'M', 'M');
//            $this->Ln(4);
//        }
//        if($this->data['company_phone']) {
//            $this->Cell(0, 4, 'Phone: '.$this->data['company_phone'], 0, false, 'C', 1, '', 0, false, 'M', 'M');
//            $this->Ln(4);
//        }
//        $this->SetTextColor(0,0,0);
//        $this->Cell(0, 4, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $this->SetFont('helvetica', 'B', 20);
            $this->Ln(2);
            // Title
            $this->Cell(0, 10, $this->data['company_name'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(8);
            $this->SetFont('helvetica', '', 8);
            $this->Cell(0, 8, $this->data['address'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(4);
            $this->Cell(0, 8,'Email: '.$this->data['email_address'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(4);
            $this->Cell(60, 8,'NTN: '.$this->data['ntn'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            //$this->Ln(4);
            $this->Cell(0, 8,'STRN: '.$this->data['strn'], 0, false, 'L', 0, '', 0, false, 'M', 'M');
            $this->Ln(10);

            /*$this->SetFont('helvetica', '', 16);
            $this->Cell(0, 8, $this->data['report_name'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
            $this->Ln(10);*/


    }

    // Page footer
    public function Footer() {
        $this->SetY(-30);
        // Set font
//        $this->SetFont('helvetica', 'B', 7);
        // Page number
        //      $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
//        $this->Cell(180, 4, '', 'B', false, 'L', 0, '', 0, false, 'M', 'M');
//        $this->Ln(10);
//        $this->Ln(5);
//        $this->Cell(25, 7, 'Prepared By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(25, 7, 'Checked By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(25, 7, 'Approved By', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(10, 7, '', 0, false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Cell(40, 7, 'Vice President Ind.Division', 'T', false, 'C', 0, '', 0, false, 'M', 'M');
//        $this->Ln(7);
//        $this->SetFont('helvetica', 'B', 8);
//        $this->Cell(0, 5, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }


}

?>